/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.views.nodes;

import java.util.ArrayList;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.index.nexus.NexusIndex;
import org.eclipse.m2e.core.internal.index.nexus.NexusIndexManager;
import org.eclipse.m2e.core.repository.IRepository;
import org.eclipse.m2e.core.repository.IRepositoryRegistry;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.views.nodes.IMavenRepositoryNode;
import org.eclipse.m2e.core.ui.internal.views.nodes.RepositoryNode;
import org.eclipse.swt.graphics.Image;

public class ProjectRepositoriesNode
implements IMavenRepositoryNode {
    private NexusIndexManager indexManager = (NexusIndexManager)MavenPlugin.getIndexManager();
    private IRepositoryRegistry repositoryRegistry = MavenPlugin.getRepositoryRegistry();

    public Object[] getChildren() {
        ArrayList<RepositoryNode> nodes = new ArrayList<RepositoryNode>();
        for (IRepository repo : this.repositoryRegistry.getRepositories(16)) {
            NexusIndex index = this.indexManager.getIndex(repo);
            RepositoryNode node = new RepositoryNode(index);
            nodes.add(node);
        }
        return nodes.toArray(new Object[nodes.size()]);
    }

    public Image getImage() {
        return MavenImages.IMG_INDEXES;
    }

    public String getName() {
        return Messages.ProjectRepositoriesNode_name;
    }

    public String toString() {
        return this.getName();
    }

    public boolean hasChildren() {
        Object[] kids = this.getChildren();
        return kids != null && kids.length > 0;
    }

    public boolean isUpdating() {
        return false;
    }
}

