/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.builder;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.Scanner;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.builder.AbstractEclipseBuildContext;
import org.eclipse.m2e.core.internal.builder.ResourceScanner;
import org.eclipse.osgi.util.NLS;
import org.sonatype.plexus.build.incremental.EmptyScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseBuildContext
extends AbstractEclipseBuildContext {
    protected final IProject project;

    public EclipseBuildContext(IProject project, Map<String, Object> context) {
        super(context);
        this.project = project;
    }

    public boolean hasDelta(String relpath) {
        return true;
    }

    public boolean hasDelta(List relpath) {
        return true;
    }

    public boolean hasDelta(File file) {
        return true;
    }

    public Scanner newDeleteScanner(File basedir) {
        return new EmptyScanner(basedir);
    }

    public Scanner newScanner(File basedir) {
        IPath relpath = this.getRelativePath(basedir);
        if (relpath != null) {
            IResource resource = this.project.findMember(relpath);
            return resource != null ? new ResourceScanner(resource) : new EmptyScanner(basedir);
        }
        File projectBasedir = this.getBaseResource().getFullPath().toFile();
        this.addMessage(projectBasedir, -1, -1, NLS.bind((String)Messages.buildConextFileAccessOutsideOfProjectBasedir, (Object)basedir), 1, null);
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(basedir);
        return ds;
    }

    public Scanner newScanner(File basedir, boolean ignoreDelta) {
        return this.newScanner(basedir);
    }

    protected IProject getBaseResource() {
        return this.project;
    }

    public boolean isIncremental() {
        return false;
    }
}

