/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project.registry;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.repository.LocalArtifactRepository;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.project.registry.MavenProjectFacade;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryManager;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.repository.WorkspaceReader;
import org.sonatype.aether.repository.WorkspaceRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EclipseWorkspaceArtifactRepository
extends LocalArtifactRepository
implements WorkspaceReader {
    private static final long serialVersionUID = 1018465082844566543L;
    private final transient ProjectRegistryManager.Context context;
    private static final ThreadLocal<Boolean> disabled = new ThreadLocal();
    private WorkspaceRepository workspaceRepository;

    public EclipseWorkspaceArtifactRepository(ProjectRegistryManager.Context context) {
        this.context = context;
        this.workspaceRepository = new WorkspaceRepository("ide", ((Object)((Object)this)).getClass());
    }

    protected File resolveAsEclipseProject(String groupId, String artifactId, String baseVersion, String classifier, String extension) {
        if (EclipseWorkspaceArtifactRepository.isDisabled()) {
            return null;
        }
        if (this.context == null) {
            return null;
        }
        ArtifactKey key = new ArtifactKey(groupId, artifactId, baseVersion, null);
        IFile pom = this.context.state.getWorkspaceArtifact(key);
        if (pom == null || !pom.isAccessible()) {
            return null;
        }
        if (this.context.pom != null && pom.equals((Object)this.context.pom)) {
            return null;
        }
        if (this.context.resolverConfiguration.shouldResolveWorkspaceProjects()) {
            IFolder outputLocation;
            MavenProjectFacade facade;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IPath file = pom.getLocation();
            if (!"pom".equals(extension) && (facade = this.context.state.getProjectFacade(pom)).getOutputLocation() != null && (outputLocation = root.getFolder(facade.getOutputLocation())).exists()) {
                file = outputLocation.getLocation();
            }
            return file.toFile();
        }
        return null;
    }

    public File findArtifact(Artifact artifact) {
        return this.resolveAsEclipseProject(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion(), artifact.getClassifier(), artifact.getExtension());
    }

    public org.apache.maven.artifact.Artifact find(org.apache.maven.artifact.Artifact artifact) {
        File file = this.resolveAsEclipseProject(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion(), artifact.getClassifier(), artifact.getType());
        if (file != null) {
            artifact.setFile(file);
            artifact.setResolved(true);
        }
        return artifact;
    }

    public boolean hasLocalMetadata() {
        return false;
    }

    public static void setDisabled(boolean disable) {
        disabled.set(disable ? Boolean.TRUE : null);
    }

    public static boolean isDisabled() {
        return Boolean.TRUE.equals(disabled.get());
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof EclipseWorkspaceArtifactRepository;
    }

    public List<String> findVersions(Artifact artifact) {
        return this.findVersions(artifact.getGroupId(), artifact.getArtifactId());
    }

    public List<String> findVersions(org.apache.maven.artifact.Artifact artifact) {
        return this.findVersions(artifact.getGroupId(), artifact.getArtifactId());
    }

    private List<String> findVersions(String groupId, String artifactId) {
        ArrayList<String> versions = new ArrayList<String>();
        if (EclipseWorkspaceArtifactRepository.isDisabled()) {
            return versions;
        }
        if (this.context == null) {
            return versions;
        }
        MavenProjectFacade[] mavenProjectFacadeArray = this.context.state.getProjects();
        int n = mavenProjectFacadeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MavenProjectFacade facade = mavenProjectFacadeArray[n2];
            ArtifactKey artifactKey = facade.getArtifactKey();
            if (groupId.equals(artifactKey.getGroupId()) && artifactId.equals(artifactKey.getArtifactId())) {
                versions.add(artifactKey.getVersion());
            }
            ++n2;
        }
        return versions;
    }

    public WorkspaceRepository getRepository() {
        return this.workspaceRepository;
    }
}

