/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.project.registry.BasicProjectRegistry;
import org.eclipse.m2e.core.internal.project.registry.Capability;
import org.eclipse.m2e.core.internal.project.registry.IProjectRegistry;
import org.eclipse.m2e.core.internal.project.registry.MavenCapability;
import org.eclipse.m2e.core.internal.project.registry.MavenProjectFacade;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistry;
import org.eclipse.m2e.core.internal.project.registry.RequiredCapability;
import org.eclipse.m2e.core.internal.project.registry.VersionlessKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableProjectRegistry
extends BasicProjectRegistry
implements IProjectRegistry {
    private static final long serialVersionUID = -4106047696261024741L;
    private final ProjectRegistry parent;
    private final int parentVersion;
    private boolean closed;

    public MutableProjectRegistry(ProjectRegistry state) {
        super(state);
        this.parent = state;
        this.parentVersion = state.getVersion();
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("Can't modify closed MutableProjectRegistry");
        }
    }

    public void setProject(IFile pom, MavenProjectFacade facade) {
        this.assertNotClosed();
        MavenProjectFacade oldFacade = (MavenProjectFacade)this.workspacePoms.remove(pom);
        if (oldFacade != null) {
            this.workspaceArtifacts.remove(oldFacade.getArtifactKey());
        }
        if (facade != null) {
            this.workspacePoms.put(pom, facade);
            this.workspaceArtifacts.put(facade.getArtifactKey(), pom);
        }
    }

    public void removeProject(IFile pom, ArtifactKey mavenProject) {
        this.assertNotClosed();
        this.removeRequiredCapabilities(pom);
        this.workspacePoms.remove(pom);
        this.projectRequirements.remove(pom);
        this.projectCapabilities.remove(pom);
        if (mavenProject != null) {
            this.workspaceArtifacts.remove(mavenProject);
        }
    }

    static boolean isSameProject(IResource r1, IResource r2) {
        if (r1 == null || r2 == null) {
            return false;
        }
        return r1.getProject().equals((Object)r2.getProject());
    }

    public Set<IFile> removeWorkspaceModules(IFile pom, ArtifactKey mavenProject) {
        this.assertNotClosed();
        return this.getDependents(MavenCapability.createMavenParent(mavenProject), true);
    }

    public boolean isStale() {
        return this.parentVersion != this.parent.getVersion();
    }

    public void close() {
        this.closed = true;
        this.clear();
    }

    private boolean isClosed() {
        return this.closed;
    }

    @Override
    public MavenProjectFacade getProjectFacade(IFile pom) {
        if (this.isClosed()) {
            return this.parent.getProjectFacade(pom);
        }
        return super.getProjectFacade(pom);
    }

    @Override
    public MavenProjectFacade getProjectFacade(String groupId, String artifactId, String version) {
        if (this.isClosed()) {
            return this.parent.getProjectFacade(groupId, artifactId, version);
        }
        return super.getProjectFacade(groupId, artifactId, version);
    }

    @Override
    public MavenProjectFacade[] getProjects() {
        if (this.isClosed()) {
            return this.parent.getProjects();
        }
        return super.getProjects();
    }

    @Override
    public IFile getWorkspaceArtifact(ArtifactKey key) {
        if (this.isClosed()) {
            return this.parent.getWorkspaceArtifact(key);
        }
        return super.getWorkspaceArtifact(key);
    }

    public Set<IFile> getDependents(Capability capability, boolean remove) {
        Map rs = (Map)this.requiredCapabilities.get(capability.getVersionlessKey());
        if (rs == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<IFile> result = new LinkedHashSet<IFile>();
        Iterator iter = rs.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!((RequiredCapability)entry.getKey()).isPotentialMatch(capability)) continue;
            result.addAll((Collection)entry.getValue());
            if (!remove) continue;
            iter.remove();
        }
        if (remove && rs.isEmpty()) {
            this.requiredCapabilities.remove(capability.getVersionlessKey());
        }
        return result;
    }

    public Set<IFile> getDependents(VersionlessKey capability, boolean remove) {
        Map rs = remove ? (Map)this.requiredCapabilities.remove(capability) : (Map)this.requiredCapabilities.get(capability);
        if (rs == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<IFile> result = new LinkedHashSet<IFile>();
        for (Set dependents : rs.values()) {
            result.addAll(dependents);
        }
        return result;
    }

    private void addRequiredCapability(IFile pom, RequiredCapability req) {
        HashSet<IFile> poms;
        HashMap<RequiredCapability, HashSet<IFile>> keyEntry = (HashMap<RequiredCapability, HashSet<IFile>>)this.requiredCapabilities.get(req.getVersionlessKey());
        if (keyEntry == null) {
            keyEntry = new HashMap<RequiredCapability, HashSet<IFile>>();
            this.requiredCapabilities.put(req.getVersionlessKey(), keyEntry);
        }
        if ((poms = (HashSet<IFile>)keyEntry.get(req)) == null) {
            poms = new HashSet<IFile>();
            keyEntry.put(req, poms);
        }
        poms.add(pom);
    }

    public Set<Capability> setCapabilities(IFile pom, Set<Capability> capabilities) {
        return capabilities != null ? this.projectCapabilities.put(pom, capabilities) : (Set<Capability>)this.projectCapabilities.remove(pom);
    }

    public Set<RequiredCapability> setRequirements(IFile pom, Set<RequiredCapability> requirements) {
        this.removeRequiredCapabilities(pom);
        if (requirements != null) {
            for (RequiredCapability requirement : requirements) {
                this.addRequiredCapability(pom, requirement);
            }
            return this.projectRequirements.put(pom, requirements);
        }
        return (Set)this.projectRequirements.remove(pom);
    }

    private void removeRequiredCapabilities(IFile pom) {
        Iterator keysIter = this.requiredCapabilities.entrySet().iterator();
        while (keysIter.hasNext()) {
            Map.Entry keysEntry = keysIter.next();
            Iterator requirementsIter = ((Map)keysEntry.getValue()).entrySet().iterator();
            while (requirementsIter.hasNext()) {
                Map.Entry requirementsEntry = requirementsIter.next();
                ((Set)requirementsEntry.getValue()).remove(pom);
                if (!((Set)requirementsEntry.getValue()).isEmpty()) continue;
                requirementsIter.remove();
            }
            if (!((Map)keysEntry.getValue()).isEmpty()) continue;
            keysIter.remove();
        }
    }
}

