/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project.registry;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.project.registry.BasicProjectRegistry;
import org.eclipse.m2e.core.internal.project.registry.IProjectRegistry;
import org.eclipse.m2e.core.internal.project.registry.MavenProjectFacade;
import org.eclipse.m2e.core.internal.project.registry.MutableProjectRegistry;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryManager;
import org.eclipse.m2e.core.internal.project.registry.RequiredCapability;
import org.eclipse.m2e.core.internal.project.registry.StaleMutableProjectRegistryException;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectRegistry
extends BasicProjectRegistry
implements Serializable,
IProjectRegistry {
    private static final long serialVersionUID = -5813062417528479711L;
    private transient int version;

    @Override
    public synchronized MavenProjectFacade getProjectFacade(IFile pom) {
        return super.getProjectFacade(pom);
    }

    @Override
    public synchronized MavenProjectFacade getProjectFacade(String groupId, String artifactId, String version) {
        return super.getProjectFacade(groupId, artifactId, version);
    }

    @Override
    public synchronized MavenProjectFacade[] getProjects() {
        return super.getProjects();
    }

    @Override
    public synchronized IFile getWorkspaceArtifact(ArtifactKey key) {
        return super.getWorkspaceArtifact(key);
    }

    public synchronized List<MavenProjectChangedEvent> apply(MutableProjectRegistry newState) throws StaleMutableProjectRegistryException {
        if (newState.isStale()) {
            throw new StaleMutableProjectRegistryException();
        }
        ArrayList<MavenProjectChangedEvent> events = new ArrayList<MavenProjectChangedEvent>();
        for (MavenProjectFacade facade : this.workspacePoms.values()) {
            if (newState.workspacePoms.containsKey(facade.getPom())) continue;
            MavenProjectChangedEvent event = new MavenProjectChangedEvent(facade.getPom(), 2, 0, facade, null);
            events.add(event);
        }
        for (MavenProjectFacade facade : newState.workspacePoms.values()) {
            MavenProjectChangedEvent event;
            MavenProjectFacade old;
            if (facade == (old = (MavenProjectFacade)this.workspacePoms.get(facade.getPom()))) continue;
            if (old != null) {
                int flags = this.hasDependencyChange(old.getPom(), newState) ? 1 : 0;
                event = new MavenProjectChangedEvent(facade.getPom(), 3, flags, old, facade);
            } else {
                event = new MavenProjectChangedEvent(facade.getPom(), 1, 0, null, facade);
            }
            events.add(event);
        }
        this.replaceWith(newState);
        ++this.version;
        return events;
    }

    public synchronized int getVersion() {
        return this.version;
    }

    private boolean hasDependencyChange(IFile pom, MutableProjectRegistry newState) {
        Set<RequiredCapability> oldRequirements = this.getProjectRequirements(pom);
        Set<RequiredCapability> requirements = newState.getProjectRequirements(pom);
        return ProjectRegistryManager.hasDiff(oldRequirements, requirements);
    }
}

