/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.project;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenUpdateRequest {
    private boolean offline = false;
    private boolean forceDependencyUpdate = false;
    private final Set<IFile> pomFiles = new LinkedHashSet<IFile>();

    public MavenUpdateRequest(boolean offline, boolean forceDependencyUpdate) {
        this.offline = offline;
        this.forceDependencyUpdate = forceDependencyUpdate;
    }

    public MavenUpdateRequest(IProject project, boolean offline, boolean updateSnapshots) {
        this(offline, updateSnapshots);
        this.addPomFile(project);
    }

    public MavenUpdateRequest(IProject[] projects, boolean offline, boolean updateSnapshots) {
        this(offline, updateSnapshots);
        int i = 0;
        while (i < projects.length) {
            this.addPomFile(projects[i]);
            ++i;
        }
    }

    public boolean isOffline() {
        return this.offline;
    }

    public boolean isForceDependencyUpdate() {
        return this.forceDependencyUpdate;
    }

    public void addPomFiles(Set<IFile> pomFiles) {
        for (IFile pomFile : pomFiles) {
            this.addPomFile(pomFile);
        }
    }

    public void addPomFile(IFile pomFile) {
        this.pomFiles.add(pomFile);
    }

    public void addPomFile(IProject project) {
        this.pomFiles.add(project.getFile("pom.xml"));
    }

    public void removePomFile(IFile pomFile) {
        this.pomFiles.remove(pomFile);
    }

    public Set<IFile> getPomFiles() {
        return this.pomFiles;
    }

    public boolean isEmpty() {
        return this.pomFiles.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        String sep = "";
        for (IFile pomFile : this.pomFiles) {
            sb.append(sep);
            sb.append(pomFile.getFullPath());
            sep = ", ";
        }
        sb.append("]");
        if (this.offline) {
            sb.append(" offline");
        }
        if (this.forceDependencyUpdate) {
            sb.append(" forceDependencyUpdate");
        }
        return sb.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MavenUpdateRequest)) {
            return false;
        }
        MavenUpdateRequest request = (MavenUpdateRequest)object;
        return this.offline == request.offline && this.forceDependencyUpdate == request.forceDependencyUpdate && this.pomFiles.equals(request.pomFiles);
    }

    public int hashCode() {
        int result = 17;
        result = result * 31 + (this.offline ? 1 : 0);
        result = result * 31 + (this.forceDependencyUpdate ? 1 : 0);
        result = result * 31 + this.pomFiles.hashCode();
        return result;
    }
}

