/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.project.conversion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.model.Model;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProjectConversionParticipant
implements IExecutableExtension {
    public static final String ATTR_ID = "id";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_AFTER = "runsAfter";
    public static final String ATTR_BEFORE = "runsBefore";
    protected Set<String> restrictedPackagings;
    private String name;
    private String id;
    private String[] runsAfter;
    private String[] runsBefore;

    public String getName() {
        return this.name;
    }

    public String getId() {
        if (this.id == null) {
            this.id = this.getClass().getName();
        }
        return this.id;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        this.id = config.getAttribute(ATTR_ID);
        this.name = config.getAttribute(ATTR_NAME);
        this.runsBefore = this.split(config.getAttribute(ATTR_BEFORE));
        this.runsAfter = this.split(config.getAttribute(ATTR_AFTER));
    }

    protected String[] split(String str) {
        if (str == null) {
            return null;
        }
        String[] split = str.split(",");
        ArrayList<String> list = new ArrayList<String>(split.length);
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if ((s = s.trim()).length() > 0 && !list.contains(s)) {
                list.add(s);
            }
            ++n2;
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    public abstract boolean accept(IProject var1) throws CoreException;

    public abstract void convert(IProject var1, Model var2, IProgressMonitor var3) throws CoreException;

    public String toString() {
        return this.name == null ? this.getId() : this.name;
    }

    public Set<String> getRestrictedPackagings() {
        return this.restrictedPackagings == null ? null : Collections.unmodifiableSet(this.restrictedPackagings);
    }

    public boolean isPackagingCompatible(String packaging) {
        boolean isCompatible = this.restrictedPackagings == null || this.restrictedPackagings.isEmpty() || this.restrictedPackagings.contains(packaging);
        return isCompatible;
    }

    public void addRestrictedPackaging(String packaging) {
        if (packaging != null) {
            if (this.restrictedPackagings == null) {
                this.restrictedPackagings = new HashSet<String>();
            }
            this.restrictedPackagings.add(packaging);
        }
    }

    public String[] getPrecedingConverterIds() {
        return this.runsAfter;
    }

    public String[] getSucceedingConverterIds() {
        return this.runsBefore;
    }
}

