/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml;

import java.io.IOException;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.m2e.core.internal.index.IndexedArtifactFile;
import org.eclipse.m2e.core.ui.internal.dialogs.MavenRepositorySearchDialog;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.editor.xml.MvnImages;
import org.eclipse.m2e.editor.xml.PomContentAssistProcessor;
import org.eclipse.m2e.editor.xml.internal.Messages;
import org.eclipse.m2e.editor.xml.internal.XmlUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InsertArtifactProposal
implements ICompletionProposal,
ICompletionProposalExtension4,
ICompletionProposalExtension5 {
    private static final Logger log = LoggerFactory.getLogger(InsertArtifactProposal.class);
    private ISourceViewer sourceViewer;
    private Region region;
    private int generatedLength = 0;
    private int generatedOffset;
    private Configuration config;

    public InsertArtifactProposal(ISourceViewer sourceViewer, Region region, Configuration config) {
        this.sourceViewer = sourceViewer;
        this.region = region;
        this.generatedOffset = region.getOffset();
        this.config = config;
        assert (config.getType() != null);
    }

    public void apply(IDocument document) {
        String path;
        MavenProject prj = XmlUtils.extractMavenProject((ITextViewer)this.sourceViewer);
        IProject eclPrj = XmlUtils.extractProject((ITextViewer)this.sourceViewer);
        MavenRepositorySearchDialog dialog = null;
        if (this.config.getType() == SearchType.PLUGIN) {
            path = XmlUtils.pathUp(this.config.getCurrentNode(), 2);
            boolean inPM = path.contains("pluginManagement");
            dialog = MavenRepositorySearchDialog.createSearchPluginDialog((Shell)this.sourceViewer.getTextWidget().getShell(), (String)this.config.getType().getWindowTitle(), (MavenProject)prj, (IProject)eclPrj, (boolean)inPM);
        }
        if (this.config.getType() == SearchType.PARENT) {
            dialog = MavenRepositorySearchDialog.createSearchParentDialog((Shell)this.sourceViewer.getTextWidget().getShell(), (String)this.config.getType().getWindowTitle(), (MavenProject)prj, (IProject)eclPrj);
        }
        if (this.config.getType() == SearchType.DEPENDENCY) {
            path = XmlUtils.pathUp(this.config.getCurrentNode(), 2);
            boolean inDM = path.contains("dependencyManagement");
            dialog = MavenRepositorySearchDialog.createSearchDependencyDialog((Shell)this.sourceViewer.getTextWidget().getShell(), (String)this.config.getType().getWindowTitle(), (MavenProject)prj, (IProject)eclPrj, (boolean)inDM);
        }
        if (dialog == null) {
            throw new IllegalStateException("Wrong search type: " + (Object)((Object)this.config.getType()));
        }
        if (this.config.getInitiaSearchString() != null) {
            dialog.setQuery(this.config.getInitiaSearchString());
        }
        final MavenRepositorySearchDialog fDialog = dialog;
        if (dialog.open() == 0) {
            final IndexedArtifactFile af = (IndexedArtifactFile)dialog.getFirstResult();
            int offset = this.region.getOffset();
            if (af != null) {
                int fOffset;
                if (this.config.getType() == SearchType.PARENT) {
                    try {
                        fOffset = offset;
                        PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple(document, new PomEdits.Operation(){

                            public void process(Document doc) {
                                Element parent = PomEdits.insertAt((Element)doc.createElement("parent"), (int)fOffset);
                                PomEdits.setText((Element)PomEdits.getChild((Element)parent, (String[])new String[]{"groupId"}), (String)af.group);
                                PomEdits.setText((Element)PomEdits.getChild((Element)parent, (String[])new String[]{"artifactId"}), (String)af.artifact);
                                PomEdits.setText((Element)PomEdits.getChild((Element)parent, (String[])new String[]{"version"}), (String)af.version);
                                String relativePath = PomContentAssistProcessor.findRelativePath(InsertArtifactProposal.this.sourceViewer, af.group, af.artifact, af.version);
                                if (relativePath != null) {
                                    PomEdits.setText((Element)PomEdits.getChild((Element)parent, (String[])new String[]{"relativePath"}), (String)relativePath);
                                }
                                PomEdits.format((Node)parent);
                                InsertArtifactProposal.this.generatedOffset = ((IndexedRegion)parent).getStartOffset();
                                InsertArtifactProposal.this.generatedLength = ((IndexedRegion)parent).getEndOffset() - InsertArtifactProposal.this.generatedOffset;
                            }
                        })});
                    }
                    catch (IOException e) {
                        log.error("Failed inserting parent element", (Throwable)e);
                    }
                    catch (CoreException e) {
                        log.error("Failed inserting parent element", (Throwable)e);
                    }
                }
                if (this.config.getType() == SearchType.PLUGIN) {
                    try {
                        fOffset = offset;
                        PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple(document, new PomEdits.Operation(){

                            public void process(Document doc) {
                                Element currentNode = PomEdits.elementAtOffset((Document)doc, (int)fOffset);
                                if (currentNode == null) {
                                    return;
                                }
                                String currentName = currentNode.getNodeName();
                                Element plugin = null;
                                Element toFormat = null;
                                if ("project".equals(currentName)) {
                                    Element build = PomEdits.findChild((Element)currentNode, (String)"build");
                                    if (build == null) {
                                        toFormat = build = PomEdits.insertAt((Element)doc.createElement("build"), (int)fOffset);
                                    }
                                    plugin = PomEdits.createElement((Element)PomEdits.getChild((Element)build, (String[])new String[]{"plugins"}), (String)"plugin");
                                }
                                if ("build".equals(currentName) || "pluginManagement".equals(currentName)) {
                                    Element plugins = PomEdits.findChild((Element)currentNode, (String)"plugins");
                                    if (plugins == null) {
                                        toFormat = plugins = PomEdits.insertAt((Element)doc.createElement("plugins"), (int)fOffset);
                                    }
                                    plugin = PomEdits.createElement((Element)plugins, (String)"plugin");
                                }
                                if ("plugins".equals(currentName)) {
                                    plugin = PomEdits.insertAt((Element)doc.createElement("plugin"), (int)fOffset);
                                }
                                if (toFormat == null) {
                                    toFormat = plugin;
                                }
                                PomEdits.setText((Element)PomEdits.getChild((Element)plugin, (String[])new String[]{"groupId"}), (String)af.group);
                                PomEdits.setText((Element)PomEdits.getChild((Element)plugin, (String[])new String[]{"artifactId"}), (String)af.artifact);
                                if (af.version != null) {
                                    PomEdits.setText((Element)PomEdits.getChild((Element)plugin, (String[])new String[]{"version"}), (String)af.version);
                                }
                                PomEdits.format((Node)toFormat);
                                InsertArtifactProposal.this.generatedOffset = ((IndexedRegion)toFormat).getStartOffset();
                                InsertArtifactProposal.this.generatedLength = ((IndexedRegion)toFormat).getEndOffset() - InsertArtifactProposal.this.generatedOffset;
                            }
                        })});
                    }
                    catch (IOException e) {
                        log.error("Failed inserting plugin element", (Throwable)e);
                    }
                    catch (CoreException e) {
                        log.error("Failed inserting plugin element", (Throwable)e);
                    }
                }
                if (this.config.getType() == SearchType.DEPENDENCY) {
                    try {
                        final int fOffset2 = offset;
                        PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple(document, new PomEdits.Operation(){

                            public void process(Document doc) {
                                Element currentNode = PomEdits.elementAtOffset((Document)doc, (int)fOffset2);
                                if (currentNode == null) {
                                    return;
                                }
                                String currentName = currentNode.getNodeName();
                                Element dependency = null;
                                Element toFormat = null;
                                if ("project".equals(currentName) || "dependencyManagement".equals(currentName) || "profile".equals(currentName)) {
                                    Element deps = PomEdits.findChild((Element)currentNode, (String)"dependencies");
                                    if (deps == null) {
                                        toFormat = deps = PomEdits.insertAt((Element)doc.createElement("dependencies"), (int)fOffset2);
                                    }
                                    dependency = doc.createElement("dependency");
                                    deps.appendChild(dependency);
                                }
                                if ("dependencies".equals(currentName)) {
                                    dependency = PomEdits.insertAt((Element)doc.createElement("dependency"), (int)fOffset2);
                                }
                                if (toFormat == null) {
                                    toFormat = dependency;
                                }
                                PomEdits.setText((Element)PomEdits.getChild((Element)dependency, (String[])new String[]{"groupId"}), (String)af.group);
                                PomEdits.setText((Element)PomEdits.getChild((Element)dependency, (String[])new String[]{"artifactId"}), (String)af.artifact);
                                if (af.version != null) {
                                    PomEdits.setText((Element)PomEdits.getChild((Element)dependency, (String[])new String[]{"version"}), (String)af.version);
                                }
                                if (fDialog.getSelectedScope() != null && !"compile".equals(fDialog.getSelectedScope())) {
                                    PomEdits.setText((Element)PomEdits.getChild((Element)dependency, (String[])new String[]{"scope"}), (String)fDialog.getSelectedScope());
                                }
                                if (af.type != null && !"jar".equals(af.type) && !"null".equals(af.type)) {
                                    PomEdits.setText((Element)PomEdits.getChild((Element)dependency, (String[])new String[]{"type"}), (String)af.type);
                                }
                                if (af.classifier != null) {
                                    PomEdits.setText((Element)PomEdits.getChild((Element)dependency, (String[])new String[]{"classifier"}), (String)af.classifier);
                                }
                                PomEdits.format((Node)toFormat);
                                InsertArtifactProposal.this.generatedOffset = ((IndexedRegion)toFormat).getStartOffset();
                                InsertArtifactProposal.this.generatedLength = ((IndexedRegion)toFormat).getEndOffset() - InsertArtifactProposal.this.generatedOffset;
                            }
                        })});
                    }
                    catch (IOException e) {
                        log.error("Failed inserting dependency element", (Throwable)e);
                    }
                    catch (CoreException e) {
                        log.error("Failed inserting dependency element", (Throwable)e);
                    }
                }
            }
        }
    }

    public Point getSelection(IDocument document) {
        return new Point(this.generatedOffset, this.generatedLength);
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public String getDisplayString() {
        return this.config.getType().getDisplayName();
    }

    public Image getImage() {
        return this.config.getType().getImage();
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public boolean isAutoInsertable() {
        return false;
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        return this.config.getType().getAdditionalInfo();
    }

    public static class Configuration {
        private final SearchType type;
        private String initiaSearchString;
        private Node node;

        public Configuration(SearchType type) {
            this.type = type;
        }

        public void setInitiaSearchString(String initiaSearchString) {
            this.initiaSearchString = initiaSearchString;
        }

        public String getInitiaSearchString() {
            return this.initiaSearchString;
        }

        public SearchType getType() {
            return this.type;
        }

        public void setCurrentNode(Node node) {
            this.node = node;
        }

        public Node getCurrentNode() {
            return this.node;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchType {
        PARENT("parents", Messages.InsertArtifactProposal_searchDialog_title, Messages.InsertArtifactProposal_display_name, MvnImages.IMG_OPEN_POM, Messages.InsertArtifactProposal_additionals),
        PLUGIN("plugin", Messages.InsertArtifactProposal_insert_plugin_title, Messages.InsertArtifactProposal_insert_plugin_display_name, MvnImages.IMG_OPEN_POM, Messages.InsertArtifactProposal_insert_plugin_description),
        DEPENDENCY("artifact", Messages.InsertArtifactProposal_insert_dep_title, Messages.InsertArtifactProposal_insert_dep_display_name, MvnImages.IMG_OPEN_POM, Messages.InsertArtifactProposal_insert_dep_desc);

        private final String type;
        private final String windowTitle;
        private final String displayName;
        private final Image image;
        private final String additionalInfo;

        private SearchType(String type, String windowTitle, String dn, Image img, String addInfo) {
            this.type = type;
            this.windowTitle = windowTitle;
            this.displayName = dn;
            this.image = img;
            this.additionalInfo = addInfo;
        }

        String getIIndexType() {
            return this.type;
        }

        public String getWindowTitle() {
            return this.windowTitle;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Image getImage() {
            return this.image;
        }

        public String getAdditionalInfo() {
            return this.additionalInfo;
        }
    }
}

