/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.m2e.editor.xml.MvnIndexPlugin;
import org.eclipse.m2e.editor.xml.internal.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLSchemaMarkerResolution
implements IMarkerResolution {
    private static final Logger log = LoggerFactory.getLogger(XMLSchemaMarkerResolution.class);

    public String getLabel() {
        return Messages.MavenMarkerResolution_schema_label;
    }

    public void run(IMarker marker) {
        if (marker.getResource().getType() == 1) {
            try {
                IDOMModel domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForEdit((IFile)marker.getResource());
                int offset = (Integer)marker.getAttribute("offset");
                IStructuredDocumentRegion regionAtCharacterOffset = domModel.getStructuredDocument().getRegionAtCharacterOffset(offset);
                if (regionAtCharacterOffset != null && regionAtCharacterOffset.getText() != null && regionAtCharacterOffset.getText().lastIndexOf("<project") >= 0) {
                    offset = regionAtCharacterOffset.getStartOffset();
                    IDE.openEditor((IWorkbenchPage)MvnIndexPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)((IFile)marker.getResource()));
                    InsertEdit edit = new InsertEdit(offset + 8, " xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\"");
                    try {
                        edit.apply((IDocument)domModel.getStructuredDocument());
                        IEditorPart activeEditor = MvnIndexPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                        MvnIndexPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().saveEditor(activeEditor, false);
                    }
                    catch (Exception e) {
                        log.error("Unable to insert schema info", (Throwable)e);
                    }
                } else {
                    String msg = Messages.MavenMarkerResolution_error;
                    MessageDialog.openError((Shell)MvnIndexPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.MavenMarkerResolution_error_title, (String)msg);
                }
            }
            catch (Exception e) {
                log.error("Unable to run quick fix for maven marker", (Throwable)e);
            }
        }
    }
}

