/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.jdt.AbstractClassifierClasspathProvider;
import org.eclipse.m2e.jdt.IClassifierClasspathProvider;
import org.eclipse.m2e.jdt.IMavenClassifierManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenClassifierManager
implements IMavenClassifierManager {
    private static final String EXTENSION_CLASSIFIER_CLASSPATH_PROVIDERS = "org.eclipse.m2e.jdt.classifierClasspathProviders";
    private static final Logger log = LoggerFactory.getLogger(MavenClassifierManager.class);
    private static final IClassifierClasspathProvider NO_OP_CLASSIFIER_CLASSPATH_PROVIDER = new AbstractClassifierClasspathProvider(){

        public String getClassifier() {
            return "(__ignore_classifier__)";
        }

        public boolean applies(IMavenProjectFacade mavenProjectFacade, String classifier) {
            return false;
        }

        public String toString() {
            return "No-Op Classifier Classpath Provider";
        }
    };
    private Map<String, List<IClassifierClasspathProvider>> classifierClasspathProvidersMap;

    @Override
    public IClassifierClasspathProvider getClassifierClasspathProvider(IMavenProjectFacade project, String classifier) {
        List<IClassifierClasspathProvider> allProviders = this.getClassifierClasspathProviders(classifier);
        ArrayList<IClassifierClasspathProvider> compatibleProviders = new ArrayList<IClassifierClasspathProvider>();
        if (allProviders != null) {
            for (IClassifierClasspathProvider p : allProviders) {
                if (!p.applies(project, classifier)) continue;
                compatibleProviders.add(p);
            }
        }
        switch (compatibleProviders.size()) {
            case 0: {
                break;
            }
            case 1: {
                return (IClassifierClasspathProvider)compatibleProviders.get(0);
            }
        }
        return NO_OP_CLASSIFIER_CLASSPATH_PROVIDER;
    }

    protected List<IClassifierClasspathProvider> getClassifierClasspathProviders(String classifier) {
        if (this.classifierClasspathProvidersMap == null) {
            this.classifierClasspathProvidersMap = MavenClassifierManager.readExtensions();
        }
        return this.classifierClasspathProvidersMap.get(classifier);
    }

    protected static synchronized Map<String, List<IClassifierClasspathProvider>> readExtensions() {
        HashMap<String, List<IClassifierClasspathProvider>> map = new HashMap<String, List<IClassifierClasspathProvider>>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ccpExtensionPoint = registry.getExtensionPoint(EXTENSION_CLASSIFIER_CLASSPATH_PROVIDERS);
        if (ccpExtensionPoint != null) {
            IExtension[] ccpExtensions;
            IExtension[] iExtensionArray = ccpExtensions = ccpExtensionPoint.getExtensions();
            int n = ccpExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    IClassifierClasspathProvider classifierClasspathProvider = null;
                    try {
                        classifierClasspathProvider = (IClassifierClasspathProvider)element.createExecutableExtension("class");
                        String classifier = classifierClasspathProvider.getClassifier();
                        ArrayList<IClassifierClasspathProvider> providers = (ArrayList<IClassifierClasspathProvider>)map.get(classifier);
                        if (providers == null) {
                            providers = new ArrayList<IClassifierClasspathProvider>(1);
                            map.put(classifier, providers);
                        }
                        providers.add(classifierClasspathProvider);
                    }
                    catch (CoreException ex) {
                        log.debug("Can not instanciate IClassifierClasspathProvider", (Throwable)ex);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return map;
    }
}

