/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.model.edit.pom.translators;

import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2e.model.edit.pom.PomFactory;
import org.eclipse.m2e.model.edit.pom.PropertyElement;
import org.eclipse.m2e.model.edit.pom.translators.ListAdapter;
import org.eclipse.m2e.model.edit.pom.translators.SSESyncResource;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesAdapter
extends ListAdapter {
    protected List<PropertyElement> properties;

    public PropertiesAdapter(SSESyncResource resc, Element containerNode, List<PropertyElement> properties) {
        super(resc, containerNode, properties, null);
        this.node = containerNode;
        this.properties = properties;
    }

    @Override
    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        block11: {
            if (this.resource.isProcessEvents()) {
                try {
                    this.resource.setProcessEvents(false);
                    if (2 == eventType && newValue instanceof Element) {
                        if (notifier == this.node) {
                            IDOMElement addedElement = (IDOMElement)newValue;
                            int idx = this.absoluteIndexOf(this.node, (Element)addedElement);
                            if (idx == -1) {
                                idx = 0;
                            }
                            this.properties.add(idx, this.createObject((Element)addedElement));
                        }
                        break block11;
                    }
                    if (3 == eventType && oldValue instanceof Element) {
                        if (notifier != this.node) break block11;
                        for (PropertyElement prop : this.properties) {
                            PropertyChildAdapter adapter = (PropertyChildAdapter)EcoreUtil.getExistingAdapter((Notifier)prop, PropertyChildAdapter.class);
                            if (!adapter.getElement().equals(oldValue)) continue;
                            this.properties.remove(prop);
                            break block11;
                        }
                        break block11;
                    }
                    if (changedFeature instanceof Text && notifier != this.node && notifier instanceof Element) {
                        Element e = (Element)notifier;
                        String name = e.getLocalName();
                        for (PropertyElement prop : this.properties) {
                            if (!name.equals(prop.getName())) continue;
                            prop.setValue(PropertiesAdapter.getElementText(e));
                        }
                    }
                }
                finally {
                    this.resource.setProcessEvents(true);
                }
            }
        }
    }

    @Override
    public void add(Object newValue, int position) {
        Element n;
        PropertyElement prop = (PropertyElement)newValue;
        Element newElement = this.node.getOwnerDocument().createElement(prop.getName());
        Text value = this.node.getOwnerDocument().createTextNode(prop.getValue());
        newElement.appendChild(value);
        if (position < 0) {
            position = 0;
        }
        if ((n = this.getNthChildWithName(this.node, "*", position)) != null) {
            this.node.insertBefore(newElement, n);
        } else {
            this.node.appendChild(newElement);
        }
        this.formatNode(newElement);
        if (EcoreUtil.getExistingAdapter((Notifier)prop, PropertyChildAdapter.class) == null) {
            prop.eAdapters().add((Object)new PropertyChildAdapter(prop, newElement));
        }
        ((IDOMNode)newElement).addAdapter((INodeAdapter)this);
    }

    @Override
    public void remove(Object oldValue, int position) {
        Element n;
        if (position == -1) {
            position = 0;
        }
        if ((n = this.getNthChildWithName(this.node, "*", position)) != null) {
            this.removeChildElement(n);
        }
    }

    public PropertyElement createObject(Element child) {
        PropertyElement propertyElement = PomFactory.eINSTANCE.createPropertyElement();
        propertyElement.setName(child.getLocalName());
        propertyElement.setValue(PropertiesAdapter.getElementText(child));
        if (((IDOMNode)child).getExistingAdapter(PropertiesAdapter.class) == null) {
            ((IDOMNode)child).addAdapter((INodeAdapter)this);
        }
        propertyElement.eAdapters().add((Object)new PropertyChildAdapter(propertyElement, child));
        return propertyElement;
    }

    @Override
    public boolean isAdapterForType(Object type) {
        return PropertiesAdapter.class.equals(type);
    }

    @Override
    public void load() {
        this.properties.clear();
        NodeList children = this.node.getChildNodes();
        int nChildren = children.getLength();
        int i = 0;
        while (i < nChildren) {
            Node child = children.item(i);
            if (child instanceof Element) {
                this.properties.add(this.createObject((Element)child));
            }
            ++i;
        }
    }

    @Override
    public void save() {
        for (PropertyElement o : this.properties) {
            this.add(o, -1);
        }
    }

    private class PropertyChildAdapter
    implements Adapter {
        private Notifier target;
        private PropertyElement property;
        private Element element;

        public PropertyChildAdapter(PropertyElement propertyElement, Element element) {
            this.property = propertyElement;
            this.element = element;
        }

        public boolean isAdapterForType(Object type) {
            return PropertyChildAdapter.class.equals(type);
        }

        public void notifyChanged(Notification notification) {
            if (PropertiesAdapter.this.resource.isProcessEvents()) {
                try {
                    PropertiesAdapter.this.resource.setProcessEvents(false);
                    Element newElement = PropertiesAdapter.this.node.getOwnerDocument().createElement(this.property.getName());
                    Text value = PropertiesAdapter.this.node.getOwnerDocument().createTextNode(this.property.getValue());
                    newElement.appendChild(value);
                    PropertiesAdapter.this.node.replaceChild(newElement, this.element);
                    PropertiesAdapter.this.formatNode(newElement);
                    this.element = newElement;
                    ((IDOMNode)newElement).addAdapter((INodeAdapter)PropertiesAdapter.this);
                }
                finally {
                    PropertiesAdapter.this.resource.setProcessEvents(true);
                }
            }
        }

        public Notifier getTarget() {
            return this.target;
        }

        public void setTarget(Notifier target) {
            this.target = target;
        }

        public PropertyElement getProperty() {
            return this.property;
        }

        public Element getElement() {
            return this.element;
        }
    }
}

