/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.tests.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadataSource;
import org.eclipse.m2e.core.internal.project.registry.MavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.tests.common.AbstractMavenProjectTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLifecycleMappingTest
extends AbstractMavenProjectTestCase {
    protected IMavenProjectRegistry mavenProjectManager;
    protected IProjectConfigurationManager projectConfigurationManager;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.mavenProjectManager = MavenPlugin.getMavenProjectRegistry();
        this.projectConfigurationManager = MavenPlugin.getProjectConfigurationManager();
    }

    @Override
    protected void tearDown() throws Exception {
        this.projectConfigurationManager = null;
        this.mavenProjectManager = null;
        super.tearDown();
    }

    protected IMavenProjectFacade importMavenProject(String basedir, String pomName) throws Exception {
        ResolverConfiguration configuration = new ResolverConfiguration();
        IProject[] project = this.importProjects(basedir, new String[]{pomName}, configuration);
        this.waitForJobsToComplete();
        return this.mavenProjectManager.create(project[0], monitor);
    }

    private LifecycleMappingMetadataSource loadLifecycleMappingMetadataSourceInternal(File metadataFile) throws IOException, XmlPullParserException {
        AbstractLifecycleMappingTest.assertTrue((String)("File does not exist:" + metadataFile.getAbsolutePath()), (boolean)metadataFile.exists());
        FileInputStream in = new FileInputStream(metadataFile);
        try {
            LifecycleMappingMetadataSource lifecycleMappingMetadataSource;
            LifecycleMappingMetadataSource lifecycleMappingMetadataSource2 = lifecycleMappingMetadataSource = LifecycleMappingFactory.createLifecycleMappingMetadataSource((InputStream)in);
            return lifecycleMappingMetadataSource2;
        }
        finally {
            IOUtil.close((InputStream)in);
        }
    }

    protected LifecycleMappingMetadataSource loadLifecycleMappingMetadataSource(String metadataFilename) throws IOException, XmlPullParserException {
        return this.loadLifecycleMappingMetadataSourceInternal(new File(metadataFilename));
    }

    protected MavenProjectFacade newMavenProjectFacade(IFile pom) throws CoreException {
        MavenProject mavenProject = MavenPlugin.getMaven().readProject(pom.getLocation().toFile(), monitor);
        MavenExecutionRequest request = MavenPlugin.getMaven().createExecutionRequest(monitor);
        MavenSession session = MavenPlugin.getMaven().createSession(request, mavenProject);
        LinkedHashMap<String, List> executionPlans = new LinkedHashMap<String, List>();
        executionPlans.put("clean", new ArrayList());
        executionPlans.put("deploy", MavenPlugin.getMaven().calculateExecutionPlan(session, mavenProject, Arrays.asList("deploy"), false, monitor).getMojoExecutions());
        executionPlans.put("site", new ArrayList());
        MavenProjectFacade facade = new MavenProjectFacade(MavenPluginActivator.getDefault().getMavenProjectManagerImpl(), pom, mavenProject, executionPlans, new ResolverConfiguration());
        return facade;
    }

    protected List<MojoExecutionKey> getNotCoveredMojoExecutions(IMavenProjectFacade facade) {
        ArrayList<MojoExecutionKey> result = new ArrayList<MojoExecutionKey>();
        Map executionMapping = facade.getMojoExecutionMapping();
        for (Map.Entry entry : executionMapping.entrySet()) {
            if (entry.getValue() != null && !((List)entry.getValue()).isEmpty() || !LifecycleMappingFactory.isInterestingPhase((String)((MojoExecutionKey)entry.getKey()).getLifecyclePhase())) continue;
            result.add((MojoExecutionKey)entry.getKey());
        }
        return result;
    }
}

