/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.lifecyclemapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.dag.DAG;
import org.codehaus.plexus.util.dag.TopologicalSorter;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.osgi.util.NLS;

public class ProjectConfigurationElementSorter {
    private List<String> sortedConfigurators;
    private Map<String, String> incompleteConfigurators;
    private Set<String> missingRequiredConfigurators;
    private Set<String> allSecondaryConfigurators = new HashSet<String>();
    private Map<String, List<String>> primaryConfigurators = new HashMap<String, List<String>>();

    public ProjectConfigurationElementSorter(Collection<String> configuratorIds, Map<String, IConfigurationElement> configurators) throws CycleDetectedException {
        Assert.isNotNull(configurators, (String)"configuratorConfigElements parameter can not be null");
        DAG fullDag = new DAG();
        DAG requirementsDag = new DAG();
        HashMap<String, String> _incompletes = new HashMap<String, String>();
        HashSet<String> _missingIds = new HashSet<String>();
        for (String key : configuratorIds) {
            String[] runsBefore;
            int n;
            String secondaryTo;
            requirementsDag.addVertex(key);
            fullDag.addVertex(key);
            IConfigurationElement configurator = configurators.get(key);
            if (configurator == null) {
                _missingIds.add(key);
                continue;
            }
            String[] runsAfter = ProjectConfigurationElementSorter.safeSplit(configurator.getAttribute("runsAfter"));
            if (runsAfter == null && (secondaryTo = configurator.getAttribute("secondaryTo")) != null) {
                runsAfter = new String[]{secondaryTo};
            }
            if (runsAfter != null) {
                String[] stringArray = runsAfter;
                n = runsAfter.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    if (!(id = id.trim()).isEmpty()) {
                        IConfigurationElement predecessor;
                        boolean isRequired = !id.endsWith("?");
                        String predecessorId = ProjectConfigurationElementSorter.sanitize(id);
                        if (isRequired) {
                            requirementsDag.addEdge(key, predecessorId);
                        }
                        if ((predecessor = configurators.get(predecessorId)) == null) {
                            if (isRequired) {
                                _missingIds.add(predecessorId);
                                _incompletes.put(key, NLS.bind((String)Messages.ProjectConfiguratorToRunAfterNotAvailable, (Object)key, (Object)predecessorId));
                            }
                        } else {
                            fullDag.addEdge(key, predecessorId);
                        }
                    }
                    ++n2;
                }
            }
            if ((runsBefore = ProjectConfigurationElementSorter.safeSplit(configurator.getAttribute("runsBefore"))) == null) continue;
            String[] stringArray = runsBefore;
            int n3 = runsBefore.length;
            n = 0;
            while (n < n3) {
                String id = stringArray[n];
                if (!(id = id.trim()).isEmpty()) {
                    IConfigurationElement successor;
                    boolean isRequired = id.endsWith("*");
                    String successorId = ProjectConfigurationElementSorter.sanitize(id);
                    if (isRequired) {
                        requirementsDag.addEdge(successorId, key);
                    }
                    if ((successor = configurators.get(successorId)) == null) {
                        if (isRequired) {
                            _missingIds.add(successorId);
                            _incompletes.put(key, NLS.bind((String)Messages.ProjectConfiguratorToRunBeforeNotAvailable, (Object)key, (Object)successorId));
                        }
                    } else {
                        fullDag.addEdge(successorId, key);
                    }
                }
                ++n;
            }
        }
        List sortedExecutions = TopologicalSorter.sort((DAG)requirementsDag);
        for (String id : sortedExecutions) {
            boolean isIncompleteOrMissing;
            boolean bl = isIncompleteOrMissing = _missingIds.contains(id) || _incompletes.containsKey(id);
            if (!isIncompleteOrMissing) continue;
            HashSet<String> dependents = new HashSet<String>();
            ProjectConfigurationElementSorter.getDependents(id, requirementsDag, dependents);
            for (String next : dependents) {
                if (!configuratorIds.contains(next) || !_missingIds.contains(next) && _incompletes.containsKey(next)) continue;
                _incompletes.put(next, NLS.bind((String)Messages.ProjectConfiguratorNotAvailable, (Object)id, (Object)next));
            }
        }
        sortedExecutions = TopologicalSorter.sort((DAG)fullDag);
        ArrayList<String> _sortedConfigurators = new ArrayList<String>(sortedExecutions.size());
        for (String id : sortedExecutions) {
            if (_incompletes.containsKey(id) || _missingIds.contains(id)) continue;
            List children = fullDag.getChildLabels(id);
            if (children == null || children.isEmpty()) {
                LinkedHashSet<String> secondaries = new LinkedHashSet<String>();
                ProjectConfigurationElementSorter.getDependents(id, fullDag, secondaries);
                this.primaryConfigurators.put(id, new ArrayList<String>(secondaries));
                this.allSecondaryConfigurators.addAll(secondaries);
            }
            _sortedConfigurators.add(id);
        }
        this.sortedConfigurators = Collections.unmodifiableList(_sortedConfigurators);
        this.incompleteConfigurators = Collections.unmodifiableMap(_incompletes);
        this.missingRequiredConfigurators = Collections.unmodifiableSet(_missingIds);
    }

    public ProjectConfigurationElementSorter(Map<String, IConfigurationElement> configurators) throws CycleDetectedException {
        this(configurators.keySet(), configurators);
    }

    private static void getDependents(String id, DAG dag, Set<String> dependents) {
        List parents = dag.getParentLabels(id);
        if (parents == null || parents.isEmpty()) {
            return;
        }
        for (String parent : parents) {
            if (!dependents.add(parent)) continue;
            ProjectConfigurationElementSorter.getDependents(parent, dag, dependents);
        }
    }

    private static String sanitize(String id) {
        return id.endsWith("?") || id.endsWith("*") ? id.substring(0, id.length() - 1) : id;
    }

    private static String[] safeSplit(String value) {
        return value == null ? null : value.split(",");
    }

    public List<String> getSortedConfigurators() {
        if (this.sortedConfigurators == null) {
            this.sortedConfigurators = Collections.emptyList();
        }
        return this.sortedConfigurators;
    }

    public Map<String, String> getIncompleteConfigurators() {
        if (this.incompleteConfigurators == null) {
            this.incompleteConfigurators = Collections.emptyMap();
        }
        return this.incompleteConfigurators;
    }

    public Set<String> getMissingConfigurators() {
        if (this.missingRequiredConfigurators == null) {
            this.missingRequiredConfigurators = Collections.emptySet();
        }
        return this.missingRequiredConfigurators;
    }

    public List<String> getSecondaryConfigurators(String primaryConfigurator) {
        List<String> secondaries = this.primaryConfigurators.get(primaryConfigurator);
        if (secondaries == null) {
            secondaries = Collections.emptyList();
        }
        return secondaries;
    }

    public boolean isRootConfigurator(String configuratorId) {
        if (configuratorId == null) {
            return false;
        }
        boolean isRoot = this.primaryConfigurators.containsKey(configuratorId);
        if (!isRoot) {
            isRoot = !this.allSecondaryConfigurators.contains(configuratorId);
        }
        return isRoot;
    }

    public String toString() {
        return "ProjectConfigurationElementSorter [" + this.getSortedConfigurators() + "]";
    }
}

