/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.discovery.strategy;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.discovery.AbstractCatalogSource;
import org.eclipse.equinox.internal.p2.discovery.compatibility.RemoteBundleDiscoveryStrategy;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.discovery.model.Certification;
import org.eclipse.equinox.internal.p2.discovery.model.ValidationException;
import org.eclipse.m2e.internal.discovery.Messages;
import org.eclipse.m2e.internal.discovery.strategy.M2EConnectorDiscoveryExtensionReader;
import org.eclipse.osgi.util.NLS;

public class M2ERemoteBundleDiscoveryStrategy
extends RemoteBundleDiscoveryStrategy {
    protected void processExtensions(IProgressMonitor monitor, IExtension[] extensions) {
        monitor.beginTask(Messages.BundleDiscoveryStrategy_task_processing_extensions, extensions.length == 0 ? 1 : extensions.length);
        try {
            M2EConnectorDiscoveryExtensionReader extensionReader = new M2EConnectorDiscoveryExtensionReader();
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                AbstractCatalogSource discoverySource = this.computeDiscoverySource(extension.getContributor());
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    block14: {
                        IConfigurationElement element = iConfigurationElementArray[n4];
                        if (monitor.isCanceled()) {
                            return;
                        }
                        try {
                            if ("connectorDescriptor".equals(element.getName())) {
                                CatalogItem descriptor = extensionReader.readConnectorDescriptor(element, CatalogItem.class);
                                descriptor.setSource(discoverySource);
                                this.items.add(descriptor);
                                break block14;
                            }
                            if ("connectorCategory".equals(element.getName())) {
                                CatalogCategory category = extensionReader.readConnectorCategory(element, CatalogCategory.class);
                                category.setSource(discoverySource);
                                if (!discoverySource.getPolicy().isPermitCategories()) {
                                    LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.discovery", NLS.bind((String)Messages.BundleDiscoveryStrategy_categoryDisallowed, (Object[])new Object[]{category.getName(), category.getId(), element.getContributor().getName()}), null));
                                } else {
                                    this.categories.add(category);
                                }
                                break block14;
                            }
                            if ("certification".equals(element.getName())) {
                                Certification certification = extensionReader.readCertification(element, Certification.class);
                                certification.setSource(discoverySource);
                                this.certifications.add(certification);
                                break block14;
                            }
                            throw new ValidationException(NLS.bind((String)Messages.BundleDiscoveryStrategy_unexpected_element, (Object)element.getName()));
                        }
                        catch (ValidationException e) {
                            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.discovery", NLS.bind((String)Messages.BundleDiscoveryStrategy_3, (Object)element.getContributor().getName(), (Object)e.getMessage()), (Throwable)e));
                        }
                    }
                    ++n4;
                }
                monitor.worked(1);
                ++n2;
            }
            this.tags.addAll(extensionReader.getTags());
        }
        finally {
            monitor.done();
        }
    }
}

