/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.preferences;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.lifecyclemapping.DefaultPluginExecutionMetadata;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingResult;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadata;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadataSource;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.PluginExecutionFilter;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.PluginExecutionMetadata;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.io.xpp3.LifecycleMappingMetadataSourceXpp3Writer;
import org.eclipse.m2e.core.internal.project.registry.MavenProjectFacade;
import org.eclipse.m2e.core.lifecyclemapping.model.IPluginExecutionMetadata;
import org.eclipse.m2e.core.lifecyclemapping.model.PluginExecutionAction;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.osgi.framework.Bundle;

public class LifecycleMappingsViewer {
    private static final String UNINTERESTING = "uninteresting";
    private static final String MAVEN_PLUGIN = "maven-plugin";
    private static final String POM = "pom";
    private static final String EXTENSION = "extension";
    private static final String DEFAULT = "default";
    private static final String UNKNOWN = "unknown";
    TreeViewer mappingsTreeViewer;
    boolean showPhases = false;
    boolean showIgnoredExecutions = true;
    final AtomicReference<Map<MojoExecutionKey, List<IPluginExecutionMetadata>>> mappings = new AtomicReference(Collections.emptyMap());
    final AtomicReference<Map<String, List<MojoExecutionKey>>> phases = new AtomicReference(Collections.emptyMap());
    private Shell shell;
    private IProject project;

    void updateMappingsTreeViewer() {
        if (this.mappingsTreeViewer == null || this.mappingsTreeViewer.getControl().isDisposed()) {
            return;
        }
        this.mappingsTreeViewer.refresh();
        Map<MojoExecutionKey, List<IPluginExecutionMetadata>> map = this.mappings.get();
        if (this.showPhases) {
            this.mappingsTreeViewer.collapseAll();
            for (Map.Entry<MojoExecutionKey, List<IPluginExecutionMetadata>> entry : map.entrySet()) {
                boolean expand = false;
                if (this.isErrorMapping(entry.getKey())) {
                    expand = true;
                } else {
                    boolean bl = expand = !this.isIgnoreMapping(entry.getKey(), entry.getValue());
                }
                if (!expand) continue;
                this.mappingsTreeViewer.expandToLevel((Object)entry.getKey().lifecyclePhase(), -1);
            }
        }
        TreeColumn[] treeColumnArray = this.mappingsTreeViewer.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.pack();
            ++n2;
        }
    }

    public Composite createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gl_container = new GridLayout(1, false);
        gl_container.marginWidth = 0;
        gl_container.marginHeight = 0;
        container.setLayout((Layout)gl_container);
        Composite optionsComposit = new Composite(container, 0);
        GridLayout gl_optionsComposit = new GridLayout(3, false);
        gl_optionsComposit.marginWidth = 0;
        gl_optionsComposit.marginHeight = 0;
        optionsComposit.setLayout((Layout)gl_optionsComposit);
        optionsComposit.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnShowPhases = new Button(optionsComposit, 32);
        btnShowPhases.setSelection(this.showPhases);
        btnShowPhases.setText(Messages.LifecycleMappingPropertyPage_showLIfecyclePhases);
        Button btnShowIgnored = new Button(optionsComposit, 32);
        btnShowIgnored.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.showIgnoredExecutions = btnShowIgnored.getSelection();
            this.updateMappingsTreeViewer();
        }));
        btnShowIgnored.setSelection(this.showIgnoredExecutions);
        btnShowIgnored.setText(Messages.LifecycleMappingPropertyPage_mntmShowIgnoredExecutions_text);
        Action actExpandAll = new Action(Messages.LifecycleMappingPropertyPage_mntmExpandAll_text, MavenImages.EXPANDALL){

            public void run() {
                LifecycleMappingsViewer.this.mappingsTreeViewer.expandAll();
            }
        };
        actExpandAll.setEnabled(this.showPhases);
        Action actCollapseAll = new Action(Messages.LifecycleMappingPropertyPage_mntmCollapseAll_text, MavenImages.COLLAPSEALL){

            public void run() {
                LifecycleMappingsViewer.this.mappingsTreeViewer.collapseAll();
            }
        };
        actCollapseAll.setEnabled(this.showPhases);
        Composite toolbarComposite = new Composite(optionsComposit, 0);
        toolbarComposite.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        GridLayout gl_toolbarComposite = new GridLayout(1, false);
        gl_toolbarComposite.marginWidth = 0;
        gl_toolbarComposite.marginHeight = 0;
        toolbarComposite.setLayout((Layout)gl_toolbarComposite);
        ToolBar toolBar = new ToolBar(toolbarComposite, 0x820000);
        ToolBarManager toolBarManager = new ToolBarManager(toolBar);
        toolBarManager.add((IAction)actExpandAll);
        toolBarManager.add((IAction)actCollapseAll);
        toolBarManager.update(true);
        btnShowPhases.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.showPhases = btnShowPhases.getSelection();
            actExpandAll.setEnabled(this.showPhases);
            actCollapseAll.setEnabled(this.showPhases);
            this.updateMappingsTreeViewer();
        }));
        this.mappingsTreeViewer = new TreeViewer(container, 2048);
        Tree tree = this.mappingsTreeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.mappingsTreeViewer, 0);
        TreeColumn trclmnGoal = treeViewerColumn.getColumn();
        trclmnGoal.setWidth(100);
        trclmnGoal.setText(Messages.LifecycleMappingPropertyPage_pluginExecution);
        TreeViewerColumn treeViewerColumn_1 = new TreeViewerColumn(this.mappingsTreeViewer, 0);
        TreeColumn trclmnNewColumn = treeViewerColumn_1.getColumn();
        trclmnNewColumn.setWidth(100);
        trclmnNewColumn.setText(Messages.LifecycleMappingPropertyPage_mapping);
        TreeViewerColumn treeViewerColumn_2 = new TreeViewerColumn(this.mappingsTreeViewer, 0);
        TreeColumn trclmnSource = treeViewerColumn_2.getColumn();
        trclmnSource.setWidth(100);
        trclmnSource.setText(Messages.LifecycleMappingsViewer_trclmnSource_text);
        this.mappingsTreeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element) != null;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                Set<Object> executions;
                if (LifecycleMappingsViewer.this.showPhases) {
                    return LifecycleMappingsViewer.this.phases.get().keySet().toArray();
                }
                if (LifecycleMappingsViewer.this.showIgnoredExecutions) {
                    executions = LifecycleMappingsViewer.this.mappings.get().keySet();
                } else {
                    executions = new LinkedHashSet();
                    for (Map.Entry<MojoExecutionKey, List<IPluginExecutionMetadata>> entry : LifecycleMappingsViewer.this.mappings.get().entrySet()) {
                        if (LifecycleMappingsViewer.this.isIgnoreMapping(entry.getKey(), entry.getValue())) continue;
                        executions.add(entry.getKey());
                    }
                }
                return executions.toArray();
            }

            public Object[] getChildren(Object parentElement) {
                List<MojoExecutionKey> executions = LifecycleMappingsViewer.this.phases.get().get(parentElement);
                if (executions == null || executions.isEmpty()) {
                    return null;
                }
                if (LifecycleMappingsViewer.this.showIgnoredExecutions) {
                    return executions.toArray();
                }
                executions = new ArrayList<MojoExecutionKey>(executions);
                Iterator<MojoExecutionKey> iter = executions.iterator();
                while (iter.hasNext()) {
                    MojoExecutionKey execution = iter.next();
                    if (!LifecycleMappingsViewer.this.isIgnoreMapping(execution, LifecycleMappingsViewer.this.mappings.get().get(execution))) continue;
                    iter.remove();
                }
                return !executions.isEmpty() ? executions.toArray() : null;
            }
        });
        this.mappingsTreeViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == 0 && element instanceof MojoExecutionKey var3_4) {
                    return LifecycleMappingsViewer.this.isErrorMapping((MojoExecutionKey)key) ? MavenImages.IMG_ERROR : MavenImages.IMG_PASSED;
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof MojoExecutionKey var3_4) {
                    switch (columnIndex) {
                        case 0: {
                            return LifecycleMappingsViewer.this.toString((MojoExecutionKey)execution);
                        }
                        case 1: {
                            return LifecycleMappingsViewer.this.toString((MojoExecutionKey)execution, LifecycleMappingsViewer.this.mappings.get().get(execution));
                        }
                        case 2: {
                            return LifecycleMappingsViewer.this.getSourcelabel((MojoExecutionKey)execution, LifecycleMappingsViewer.this.mappings.get().get(execution), false);
                        }
                    }
                }
                return columnIndex == 0 ? element.toString() : null;
            }
        });
        Composite actionsComposite = new Composite(container, 0);
        actionsComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        actionsComposite.setLayout((Layout)new GridLayout(2, false));
        Label infoLabel = new Label(actionsComposite, 0);
        infoLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnCopyToClipboard = new Button(actionsComposite, 0);
        btnCopyToClipboard.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.copyToClipboard()));
        btnCopyToClipboard.setText(Messages.LifecycleMappingPropertyPage_copyToClipboard);
        this.mappingsTreeViewer.setInput(this.phases);
        this.mappingsTreeViewer.addSelectionChangedListener(e -> {
            Object element = e.getStructuredSelection().getFirstElement();
            if (element instanceof MojoExecutionKey var4_5) {
                infoLabel.setText(this.getSourcelabel((MojoExecutionKey)execution, this.mappings.get().get(execution), true));
            } else {
                infoLabel.setText("");
            }
        });
        this.updateMappingsTreeViewer();
        return container;
    }

    void copyToClipboard() {
        Map<MojoExecutionKey, List<IPluginExecutionMetadata>> map = this.mappings.get();
        if (map.isEmpty()) {
            return;
        }
        LifecycleMappingMetadata meta = new LifecycleMappingMetadata();
        for (Map.Entry<MojoExecutionKey, List<IPluginExecutionMetadata>> entry : this.mappings.get().entrySet()) {
            MojoExecutionKey execution = entry.getKey();
            List<IPluginExecutionMetadata> mappings = entry.getValue();
            if (mappings != null && !mappings.isEmpty()) {
                for (IPluginExecutionMetadata mapping : mappings) {
                    PluginExecutionMetadata clone = ((PluginExecutionMetadata)mapping).clone();
                    this.setMappingSource(execution, mappings, clone);
                    meta.addPluginExecution(clone);
                }
                continue;
            }
            PluginExecutionFilter filter = new PluginExecutionFilter(execution.groupId(), execution.artifactId(), execution.version(), execution.goal());
            PluginExecutionMetadata mapping = new PluginExecutionMetadata();
            mapping.setFilter(filter);
            Xpp3Dom actionDom = LifecycleMappingFactory.isInterestingPhase((String)entry.getKey().lifecyclePhase()) ? new Xpp3Dom(PluginExecutionAction.error.toString()) : new Xpp3Dom(PluginExecutionAction.ignore.toString());
            mapping.setActionDom((Object)actionDom);
            this.setMappingSource(execution, mappings, mapping);
            meta.addPluginExecution(mapping);
        }
        LifecycleMappingMetadataSource xml = new LifecycleMappingMetadataSource();
        xml.addLifecycleMapping(meta);
        StringWriter buf = new StringWriter();
        try {
            new LifecycleMappingMetadataSourceXpp3Writer().write((Writer)buf, xml);
            Clipboard clipboard = new Clipboard(this.shell.getDisplay());
            Object[] data = new Object[]{buf.toString()};
            Transfer[] dataTypes = new Transfer[]{TextTransfer.getInstance()};
            clipboard.setContents(data, dataTypes);
            clipboard.dispose();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void setMappingSource(MojoExecutionKey execution, List<IPluginExecutionMetadata> mappings, PluginExecutionMetadata clone) {
        clone.setComment("source: " + this.getSourcelabel(execution, mappings, true));
    }

    boolean isErrorMapping(MojoExecutionKey execution) {
        List<IPluginExecutionMetadata> mappings = this.mappings.get().get(execution);
        if (mappings == null || mappings.isEmpty()) {
            return LifecycleMappingFactory.isInterestingPhase((String)execution.lifecyclePhase());
        }
        for (IPluginExecutionMetadata mapping : mappings) {
            if (PluginExecutionAction.error != mapping.getAction()) continue;
            return true;
        }
        return false;
    }

    boolean isIgnoreMapping(MojoExecutionKey execution, List<IPluginExecutionMetadata> mappings) {
        if (mappings == null || mappings.isEmpty()) {
            return !LifecycleMappingFactory.isInterestingPhase((String)execution.lifecyclePhase());
        }
        for (IPluginExecutionMetadata mapping : mappings) {
            if (PluginExecutionAction.ignore == mapping.getAction()) continue;
            return false;
        }
        return true;
    }

    String toString(MojoExecutionKey execution, List<IPluginExecutionMetadata> mappings) {
        if (mappings != null && !mappings.isEmpty()) {
            return mappings.stream().map(IPluginExecutionMetadata::getAction).map(Enum::toString).distinct().collect(Collectors.joining(", "));
        }
        if (LifecycleMappingFactory.isInterestingPhase((String)execution.lifecyclePhase())) {
            return PluginExecutionAction.error.toString();
        }
        return PluginExecutionAction.ignore.toString();
    }

    String getSourcelabel(MojoExecutionKey execution, List<IPluginExecutionMetadata> mappings, boolean detailed) {
        LinkedHashSet<Object> sources = new LinkedHashSet<Object>();
        if (mappings != null && !mappings.isEmpty()) {
            for (IPluginExecutionMetadata mapping : mappings) {
                if (mapping instanceof PluginExecutionMetadata var7_7) {
                    LifecycleMappingMetadataSource metadataSource = metadata.getSource();
                    if (metadataSource == null) {
                        sources.add(UNKNOWN);
                        continue;
                    }
                    Object source = metadataSource.getSource();
                    if (source instanceof String var12_11) {
                        sources.add(s);
                        continue;
                    }
                    if (source instanceof Artifact var15_13) {
                        sources.add(this.getSourceLabel((Artifact)artifact, detailed));
                        continue;
                    }
                    if (source instanceof MavenProject var18_15) {
                        sources.add(this.getSourceLabel((MavenProject)mavenProject, detailed));
                        continue;
                    }
                    if (source instanceof Bundle var21_17) {
                        sources.add(this.getSourceLabel((Bundle)bundle, detailed));
                        continue;
                    }
                    sources.add(UNKNOWN);
                    continue;
                }
                if (mapping instanceof DefaultPluginExecutionMetadata) {
                    sources.add(DEFAULT);
                    continue;
                }
                sources.add(UNKNOWN);
            }
        } else if (!LifecycleMappingFactory.isInterestingPhase((String)execution.lifecyclePhase())) {
            sources.add(UNINTERESTING);
        }
        return String.join((CharSequence)", ", sources);
    }

    private String getSourceLabel(Bundle bundle, boolean detailed) {
        StringBuilder sb = new StringBuilder(EXTENSION);
        if (detailed) {
            sb.append('(').append(bundle.getSymbolicName()).append('_').append(bundle.getVersion()).append(')');
        }
        return sb.toString();
    }

    private String getSourceLabel(MavenProject project, boolean detailed) {
        StringBuilder sb = new StringBuilder(POM);
        if (detailed) {
            sb.append('(').append(project.toString()).append(')');
        }
        return sb.toString();
    }

    private String getSourceLabel(Artifact plugin, boolean detailed) {
        StringBuilder sb = new StringBuilder(MAVEN_PLUGIN);
        if (detailed) {
            sb.append('(').append(plugin.toString()).append(')');
        }
        return sb.toString();
    }

    String toString(MojoExecutionKey execution) {
        StringBuilder sb = new StringBuilder();
        String artifactId = execution.artifactId();
        if (artifactId.endsWith("-maven-plugin")) {
            artifactId = artifactId.substring(0, artifactId.length() - "-maven-plugin".length());
        } else if (artifactId.startsWith("maven-") && artifactId.endsWith("-plugin")) {
            artifactId = artifactId.substring("maven-".length(), artifactId.length() - "-plugin".length());
        }
        sb.append(artifactId).append(':').append(execution.goal());
        int count = 0;
        for (MojoExecutionKey other : this.mappings.get().keySet()) {
            if (!LifecycleMappingsViewer.eq(execution.groupId(), other.groupId()) || !LifecycleMappingsViewer.eq(execution.artifactId(), other.artifactId()) || !LifecycleMappingsViewer.eq(execution.goal(), other.goal())) continue;
            ++count;
        }
        if (count > 1) {
            sb.append(" (").append(execution.executionId()).append(")");
        }
        return sb.toString();
    }

    static <T> boolean eq(T a, T b) {
        return a != null ? a.equals(b) : b == null;
    }

    public void setTarget(IProject project) {
        if (this.project == project) {
            return;
        }
        this.project = project;
        this.phases.set(Collections.emptyMap());
        this.mappings.set(Collections.emptyMap());
        this.updateMappingsTreeViewer();
        if (project != null) {
            Job job = Job.create((String)("Compute Mappings for project " + project.getName()), monitor -> {
                IMavenProjectRegistry projectRegistry = MavenPlugin.getMavenProjectRegistry();
                IMavenProjectFacade facade = projectRegistry.getProject(project);
                if (facade == null) {
                    return;
                }
                projectRegistry.execute(facade, (context, monitor1) -> {
                    MavenProject mavenProject = facade.getMavenProject(monitor1);
                    List mojoExecutions = ((MavenProjectFacade)facade).getMojoExecutions(monitor1);
                    LifecycleMappingResult mappingResult = LifecycleMappingFactory.calculateLifecycleMapping((MavenProject)mavenProject, (List)mojoExecutions, (String)facade.getConfiguration().getLifecycleMappingId(), (IProgressMonitor)monitor1);
                    Map result = mappingResult.getMojoExecutionMapping();
                    LinkedHashMap<String, ArrayList<MojoExecutionKey>> phases = new LinkedHashMap<String, ArrayList<MojoExecutionKey>>();
                    if (result != null) {
                        for (MojoExecutionKey execution : result.keySet()) {
                            ArrayList<MojoExecutionKey> executions = (ArrayList<MojoExecutionKey>)phases.get(execution.lifecyclePhase());
                            if (executions == null) {
                                executions = new ArrayList<MojoExecutionKey>();
                                phases.put(execution.lifecyclePhase(), executions);
                            }
                            executions.add(execution);
                        }
                        this.phases.set(phases);
                        this.mappings.set(result);
                    }
                    Display.getDefault().asyncExec(this::updateMappingsTreeViewer);
                    return null;
                }, monitor);
            });
            job.schedule();
        }
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }
}

