/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.internal.launch;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.m2e.core.project.IMavenProjectChangedListener;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.jdt.internal.launch.MavenRuntimeClasspathProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenLaunchConfigurationListener
implements ILaunchConfigurationListener,
IMavenProjectChangedListener {
    private static final Logger log = LoggerFactory.getLogger(MavenLaunchConfigurationListener.class);

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        this.updateLaunchConfiguration(configuration);
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
        this.updateLaunchConfiguration(configuration);
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
    }

    private void updateLaunchConfiguration(ILaunchConfiguration configuration) {
        try {
            if (!MavenRuntimeClasspathProvider.isSupportedType(configuration.getType().getIdentifier())) {
                return;
            }
            IJavaProject javaProject = JavaRuntime.getJavaProject((ILaunchConfiguration)configuration);
            if (javaProject != null && javaProject.getProject().hasNature("org.eclipse.m2e.core.maven2Nature")) {
                if (!configuration.getAttributes().containsKey(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER)) {
                    MavenRuntimeClasspathProvider.enable(configuration);
                }
                this.setModuleNameForLaunchersFromTestFolder(javaProject, configuration);
            }
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setModuleNameForLaunchersFromTestFolder(IJavaProject javaProject, ILaunchConfiguration config) throws CoreException {
        if (this.isLaunchConfigWithMainFromTestFolder(javaProject, config)) {
            IModuleDescription module = javaProject.getModuleDescription();
            String modName = module == null ? null : module.getElementName();
            String currentModuleName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MODULE_NAME, null);
            if (modName != null && modName.length() > 0 && !modName.equals(currentModuleName)) {
                ILaunchConfiguration iLaunchConfiguration = config;
                if (iLaunchConfiguration instanceof ILaunchConfigurationWorkingCopy) {
                    void wc;
                    ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = (ILaunchConfigurationWorkingCopy)iLaunchConfiguration;
                    ILaunchConfigurationWorkingCopy cfr_ignored_0 = (ILaunchConfigurationWorkingCopy)iLaunchConfiguration;
                    wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MODULE_NAME, modName);
                } else {
                    ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                    wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MODULE_NAME, modName);
                    wc.doSave();
                }
            }
        }
    }

    private boolean isLaunchConfigWithMainFromTestFolder(IJavaProject javaProject, ILaunchConfiguration config) throws CoreException {
        String mainType = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
        if (mainType == null) {
            return false;
        }
        IType findType = javaProject.findType(mainType);
        if (findType == null) {
            return false;
        }
        IJavaElement javaElement = findType.getAncestor(3);
        if (javaElement instanceof IPackageFragmentRoot) {
            IPath path = javaElement.getPath();
            return "test".equals(path.segment(path.segmentCount() - 2));
        }
        return true;
    }

    public void mavenProjectChanged(List<MavenProjectChangedEvent> events, IProgressMonitor monitor) {
        for (MavenProjectChangedEvent event : events) {
            try {
                switch (event.getKind()) {
                    case 1: {
                        MavenRuntimeClasspathProvider.enable(event.getMavenProject().getProject());
                        break;
                    }
                    case 2: {
                        MavenRuntimeClasspathProvider.disable(event.getOldMavenProject().getProject());
                        break;
                    }
                }
            }
            catch (Exception e) {
                log.error("Could not update launch configuration", (Throwable)e);
            }
        }
    }
}

