/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.M2EUtils;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.builder.BuildDebugHook;
import org.eclipse.m2e.core.internal.builder.DeltaProvider;
import org.eclipse.m2e.core.internal.builder.MavenBuilderImpl;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryManager;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IProjectConfiguration;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.configurator.AbstractBuildParticipant;
import org.eclipse.m2e.core.project.configurator.ILifecycleMapping;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenBuilder
extends IncrementalProjectBuilder
implements DeltaProvider {
    private static final Logger log = LoggerFactory.getLogger(MavenBuilder.class);
    final MavenBuilderImpl builder = new MavenBuilderImpl(this);
    private final ProjectRegistryManager projectManager = MavenPluginActivator.getDefault().getMavenProjectManagerImpl();
    private final IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
    private final IMavenMarkerManager markerManager = MavenPluginActivator.getDefault().getMavenMarkerManager();
    private final BuildMethod<IProject[]> methodBuild = new BuildMethod<IProject[]>(this){

        @Override
        protected IProject[] method(IMavenExecutionContext context, IMavenProjectFacade projectFacade, Map<MojoExecutionKey, List<AbstractBuildParticipant>> buildParticipantsByMojoExecutionKey, int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
            Set<IProject> dependencies = builder.build(context.getSession(), projectFacade, kind, args, buildParticipantsByMojoExecutionKey, monitor);
            if (dependencies.isEmpty()) {
                return null;
            }
            return dependencies.toArray(new IProject[dependencies.size()]);
        }
    };
    private final BuildMethod<Void> methodClean = new BuildMethod<Void>(this){

        @Override
        protected Void method(IMavenExecutionContext context, IMavenProjectFacade projectFacade, Map<MojoExecutionKey, List<AbstractBuildParticipant>> buildParticipantsByMojoExecutionKey, int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
            builder.clean(context.getSession(), projectFacade, buildParticipantsByMojoExecutionKey, monitor);
            return null;
        }
    };
    private static final List<BuildDebugHook> debugHooks = new ArrayList<BuildDebugHook>();

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        log.debug("Building project {}", (Object)this.getProject().getName());
        long start = System.currentTimeMillis();
        try {
            IProject[] iProjectArray = this.methodBuild.execute(kind, args, monitor);
            return iProjectArray;
        }
        finally {
            log.debug("Built project {} in {} ms", (Object)this.getProject().getName(), (Object)(System.currentTimeMillis() - start));
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        log.debug("Cleaning project {}", (Object)this.getProject().getName());
        long start = System.currentTimeMillis();
        try {
            this.methodClean.execute(15, Collections.emptyMap(), monitor);
        }
        finally {
            log.debug("Cleaned project {} in {} ms", (Object)this.getProject().getName(), (Object)(System.currentTimeMillis() - start));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDebugHook(BuildDebugHook hook) {
        List<BuildDebugHook> list = debugHooks;
        synchronized (list) {
            if (debugHooks.stream().noneMatch(h -> h == hook)) {
                debugHooks.add(hook);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDebugHook(BuildDebugHook hook) {
        List<BuildDebugHook> list = debugHooks;
        synchronized (list) {
            debugHooks.removeIf(h -> h == hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<BuildDebugHook> getDebugHooks() {
        List<BuildDebugHook> list = debugHooks;
        synchronized (list) {
            return new ArrayList<BuildDebugHook>(debugHooks);
        }
    }

    public ISchedulingRule getRule(int kind, Map<String, String> args) {
        if (MavenPlugin.getMavenConfiguration().buildWithNullSchedulingRule()) {
            return null;
        }
        return super.getRule(kind, args);
    }

    static /* synthetic */ IProjectConfigurationManager access$0(MavenBuilder mavenBuilder) {
        return mavenBuilder.configurationManager;
    }

    private abstract class BuildMethod<T> {
        private BuildMethod() {
        }

        public final T execute(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
            IProject project = MavenBuilder.this.getProject();
            boolean includeSubtypes = kind == 6 || kind == 15;
            MavenBuilder.this.markerManager.deleteMarkers((IResource)project, includeSubtypes, "org.eclipse.m2e.core.maven2Problem.build");
            IFile pomResource = project.getFile("pom.xml");
            if (pomResource == null) {
                return null;
            }
            IProjectConfiguration resolverConfiguration = MavenBuilder.this.configurationManager.getProjectConfiguration(project);
            if (resolverConfiguration == null) {
                return null;
            }
            IMavenExecutionContext context = MavenBuilder.this.projectManager.createExecutionContext(pomResource, resolverConfiguration);
            return (T)context.execute((context2, monitor2) -> {
                MavenProject mavenProject;
                IMavenProjectFacade projectFacade = this.getProjectFacade(project, monitor2);
                if (projectFacade == null) {
                    return null;
                }
                try {
                    mavenProject = projectFacade.getMavenProject(monitor2);
                }
                catch (CoreException ce) {
                    this.addErrorMarker(project, (Exception)((Object)ce));
                    return null;
                }
                return context2.execute(mavenProject, (IMavenExecutionContext context1, IProgressMonitor monitor1) -> {
                    ILifecycleMapping lifecycleMapping = MavenBuilder.this.configurationManager.getLifecycleMapping(projectFacade);
                    if (lifecycleMapping == null) {
                        return null;
                    }
                    Map<MojoExecutionKey, List<AbstractBuildParticipant>> buildParticipantsByMojoExecutionKey = lifecycleMapping.getBuildParticipants(projectFacade, monitor1);
                    return this.method(context1, projectFacade, buildParticipantsByMojoExecutionKey, kind, args, monitor1);
                }, monitor2);
            }, monitor);
        }

        abstract T method(IMavenExecutionContext var1, IMavenProjectFacade var2, Map<MojoExecutionKey, List<AbstractBuildParticipant>> var3, int var4, Map<String, String> var5, IProgressMonitor var6) throws CoreException;

        void addErrorMarker(IProject project, Exception e) {
            Object msg = e.getMessage();
            String rootCause = M2EUtils.getRootCauseMessage(e);
            if (msg != null && !((String)msg).equals(rootCause)) {
                msg = (String)msg + ": " + rootCause;
            }
            MavenBuilder.this.markerManager.addMarker((IResource)project, "org.eclipse.m2e.core.maven2Problem.build", (String)msg, 1, 2);
        }

        IMavenProjectFacade getProjectFacade(IProject project, IProgressMonitor monitor) throws CoreException {
            IFile pomResource = project.getFile("pom.xml");
            boolean force = false;
            IResourceDelta delta = MavenBuilder.this.getDelta(project);
            if (delta != null) {
                force = (delta = delta.findMember(pomResource.getFullPath())) != null && delta.getKind() == 4;
            }
            IMavenProjectFacade projectFacade = MavenBuilder.this.projectManager.getProject(project);
            if (force || projectFacade == null || projectFacade.isStale()) {
                MavenBuilder.this.projectManager.refresh(Collections.singleton(pomResource), monitor);
                projectFacade = MavenBuilder.this.projectManager.getProject(project);
                if (projectFacade == null) {
                    return null;
                }
            }
            return projectFacade;
        }
    }
}

