/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.target;

import java.util.Collection;
import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.pde.target.DependencyDepth;
import org.eclipse.m2e.pde.target.MavenTargetDependency;
import org.eclipse.m2e.pde.target.MavenTargetDependencyFilter;
import org.eclipse.m2e.pde.target.MavenTargetLocation;

final class DependencyNodeGenerator {
    private DependencyNodeGenerator() {
    }

    static ICallable<PreorderNodeListGenerator> create(MavenTargetDependency root, Artifact artifact, DependencyDepth dependencyDepth, Collection<String> dependencyScopes, List<ArtifactRepository> repositories, MavenTargetLocation parent) {
        return (context, monitor) -> {
            try {
                CollectRequest collectRequest = new CollectRequest();
                collectRequest.setRoot(new Dependency(artifact, null));
                collectRequest.setRepositories(RepositoryUtils.toRepos((List)repositories));
                RepositorySystem repoSystem = MavenPluginActivator.getDefault().getRepositorySystem();
                DependencyNode node = repoSystem.collectDependencies(context.getRepositorySession(), collectRequest).getRoot();
                node.setData((Object)"dependencynode.parent", (Object)parent);
                node.setData((Object)"dependencynode.root", (Object)root);
                DependencyRequest dependencyRequest = new DependencyRequest();
                dependencyRequest.setRoot(node);
                dependencyRequest.setFilter((DependencyFilter)new MavenTargetDependencyFilter(dependencyDepth, dependencyScopes));
                repoSystem.resolveDependencies(context.getRepositorySession(), dependencyRequest);
                PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
                node.accept((DependencyVisitor)nlg);
                return nlg;
            }
            catch (RepositoryException e) {
                throw new CoreException(Status.error((String)"Resolving dependencies failed", (Throwable)e));
            }
            catch (RuntimeException e) {
                throw new CoreException(Status.error((String)"Internal error", (Throwable)e));
            }
        };
    }
}

