/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format;

import java.util.List;
import org.eclipse.lemminx.dom.DOMCDATASection;
import org.eclipse.lemminx.services.format.XMLFormatterDocument;
import org.eclipse.lemminx.services.format.XMLFormattingConstraints;
import org.eclipse.lsp4j.TextEdit;

public class DOMCDATAFormatter {
    private final XMLFormatterDocument formatterDocument;

    public DOMCDATAFormatter(XMLFormatterDocument formatterDocument) {
        this.formatterDocument = formatterDocument;
    }

    public void formatCDATASection(DOMCDATASection cDATANode, XMLFormattingConstraints parentConstraints, List<TextEdit> edits) {
        int leftWhitespaceOffset;
        String text = this.formatterDocument.getText();
        int start = cDATANode.getStart();
        int n = leftWhitespaceOffset = start > 0 ? start - 1 : 0;
        while (leftWhitespaceOffset > 0 && Character.isWhitespace(text.charAt(leftWhitespaceOffset))) {
            --leftWhitespaceOffset;
        }
        if (this.isJoinCDATALines()) {
            int availableLineWidth = parentConstraints.getAvailableLineWidth();
            int spaceStart = -1;
            int spaceEnd = -1;
            int contentEnd = -1;
            int cDATAStartContent = cDATANode.getStartContent();
            int cDATAEndContent = cDATANode.getEndContent();
            for (int i = cDATAStartContent; i <= cDATAEndContent; ++i) {
                char c = text.charAt(i);
                if (Character.isWhitespace(c)) {
                    if (spaceStart == -1) {
                        spaceStart = i;
                        continue;
                    }
                    spaceEnd = i;
                    continue;
                }
                int contentStart = i;
                while (i < cDATAEndContent && !Character.isWhitespace(text.charAt(i + 1))) {
                    ++i;
                }
                contentEnd = i;
                if (this.isMaxLineWidthSupported()) {
                    if ((availableLineWidth -= contentEnd + 1 - contentStart) <= 0 && spaceStart != -1) {
                        this.replaceLeftSpacesWithIndentation(parentConstraints.getIndentLevel(), spaceStart, contentStart, true, edits);
                        int indentSpaces = this.getTabSize() * parentConstraints.getIndentLevel();
                        availableLineWidth = this.getMaxLineWidth() - indentSpaces - (contentEnd + 1 - contentStart);
                        continue;
                    }
                    if (spaceStart != cDATAStartContent && contentEnd != cDATAEndContent) {
                        --availableLineWidth;
                    }
                }
                if (spaceStart == cDATAStartContent) {
                    this.removeLeftSpaces(spaceStart, contentStart, edits);
                    spaceStart = -1;
                    spaceEnd = -1;
                    continue;
                }
                if (contentEnd == cDATAEndContent) {
                    this.removeLeftSpaces(spaceStart, contentEnd, edits);
                    spaceStart = -1;
                    spaceEnd = -1;
                    continue;
                }
                this.replaceSpacesWithOneSpace(spaceStart, spaceEnd, edits);
                spaceStart = -1;
                spaceEnd = -1;
            }
        }
    }

    private void removeLeftSpaces(int from, int to, List<TextEdit> edits) {
        this.formatterDocument.removeLeftSpaces(from, to, edits);
    }

    private boolean isJoinCDATALines() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().isJoinCDATALines();
    }

    private int getTabSize() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().getTabSize();
    }

    private int getMaxLineWidth() {
        return this.formatterDocument.getMaxLineWidth();
    }

    private void replaceSpacesWithOneSpace(int spaceStart, int spaceEnd, List<TextEdit> edits) {
        this.formatterDocument.replaceSpacesWithOneSpace(spaceStart, spaceEnd, edits);
    }

    private int replaceLeftSpacesWithIndentation(int indentLevel, int from, int to, boolean addLineSeparator, List<TextEdit> edits) {
        return this.formatterDocument.replaceLeftSpacesWithIndentation(indentLevel, from, to, addLineSeparator, edits);
    }

    private boolean isMaxLineWidthSupported() {
        return this.formatterDocument.isMaxLineWidthSupported();
    }
}

