/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.model.edit.pom.translators;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2e.model.edit.pom.Model;
import org.eclipse.m2e.model.edit.pom.PomFactory;
import org.eclipse.m2e.model.edit.pom.translators.ModelObjectAdapter;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SSESyncResource
extends ResourceImpl {
    private static final Set<String> NO_EVENT_MODELS = new HashSet<String>();
    private IDOMModel domModel;
    private Model pomModel;
    private Document doc;

    public SSESyncResource() {
    }

    public SSESyncResource(URI uri) {
        super(uri);
    }

    public void load(Map<?, ?> options) throws IOException {
        if (this.isLoaded()) {
            return;
        }
        this.loadDOMModel();
        this.setProcessEvents(false);
        try {
            this.pomModel = PomFactory.eINSTANCE.createModel();
            this.doc = this.domModel.getDocument();
            DocumentAdapter da = new DocumentAdapter();
            if (this.doc.getDocumentElement() != null) {
                this.createAdapterForRootNode(this.domModel.getDocument().getDocumentElement()).load();
            } else {
                this.pomModel.eAdapters().add((Object)da);
            }
            ((IDOMNode)this.doc).addAdapter((INodeAdapter)da);
            this.getContents().add((Object)this.pomModel);
            this.setLoaded(true);
        }
        finally {
            this.setProcessEvents(true);
        }
    }

    protected void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        try {
            this.domModel.save(outputStream);
        }
        catch (CoreException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    protected void doUnload() {
        this.domModel.releaseFromEdit();
    }

    private void loadDOMModel() throws IOException {
        block18: {
            Throwable throwable;
            File f;
            IFile ifile = null;
            if (this.uri.isPlatformResource()) {
                String localPath = this.uri.toPlatformString(true);
                ifile = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(localPath);
            } else if (this.uri.isFile()) {
                String filePath = this.uri.toFileString();
                f = new File(filePath);
                IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(f.getAbsoluteFile().toURI());
                if (files.length > 0) {
                    ifile = files[0];
                }
            }
            try {
                IModelManager modelManager = StructuredModelManager.getModelManager();
                if (ifile != null && ifile.exists()) {
                    this.domModel = (IDOMModel)modelManager.getExistingModelForEdit(ifile);
                }
                if (this.domModel != null) break block18;
                if (ifile != null && ifile.exists()) {
                    this.domModel = (IDOMModel)modelManager.getModelForEdit(ifile);
                    break block18;
                }
                if (!this.uri.isFile()) break block18;
                f = new File(this.uri.toFileString());
                throwable = null;
                Object var5_7 = null;
                try (FileInputStream is = new FileInputStream(f);){
                    this.domModel = (IDOMModel)modelManager.getModelForEdit(f.getAbsolutePath(), (InputStream)is, null);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (CoreException e) {
                if (e.getCause() != null && (throwable = e.getCause()) instanceof IOException) {
                    IOException ioException = (IOException)throwable;
                    throw ioException;
                }
                throw new IOException(e.getMessage());
            }
        }
    }

    private ModelObjectAdapter createAdapterForRootNode(Element root) {
        ModelObjectAdapter adapter = new ModelObjectAdapter(this, this.pomModel, root);
        ((IDOMElement)root).addAdapter((INodeAdapter)adapter);
        this.pomModel.eAdapters().add((Object)adapter);
        return adapter;
    }

    boolean isProcessEvents() {
        return !NO_EVENT_MODELS.contains(this.domModel.getId());
    }

    void setProcessEvents(boolean processEvents) {
        if (processEvents) {
            NO_EVENT_MODELS.remove(this.domModel.getId());
        } else {
            NO_EVENT_MODELS.add(this.domModel.getId());
        }
    }

    private class DocumentAdapter
    implements INodeAdapter,
    Adapter {
        private Notifier target;

        private DocumentAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return this.getClass().equals(type);
        }

        public void notifyChanged(Notification notification) {
            if (SSESyncResource.this.isProcessEvents()) {
                SSESyncResource.this.setProcessEvents(false);
                try {
                    int type = notification.getEventType();
                    if (3 == type || 5 == type || 1 == type) {
                        if (SSESyncResource.this.doc.getDocumentElement() == null) {
                            Element newRoot = SSESyncResource.this.doc.createElementNS("http://maven.apache.org/POM/4.0.0", "project");
                            newRoot.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd");
                            newRoot.setAttribute("xmlns", "http://maven.apache.org/POM/4.0.0");
                            newRoot.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                            SSESyncResource.this.doc.appendChild(newRoot);
                            SSESyncResource.this.pomModel.setModelVersion("4.0.0");
                            SSESyncResource.this.createAdapterForRootNode(newRoot).save();
                        } else {
                            Element root = SSESyncResource.this.doc.getDocumentElement();
                            SSESyncResource.this.createAdapterForRootNode(root).load();
                        }
                        DocumentAdapter existingDocAdapter = (DocumentAdapter)EcoreUtil.getExistingAdapter((Notifier)SSESyncResource.this.pomModel, DocumentAdapter.class);
                        if (existingDocAdapter != null) {
                            SSESyncResource.this.pomModel.eAdapters().remove((Object)existingDocAdapter);
                        }
                    }
                }
                finally {
                    SSESyncResource.this.setProcessEvents(true);
                }
            }
        }

        public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
            if (SSESyncResource.this.isProcessEvents()) {
                SSESyncResource.this.setProcessEvents(false);
                try {
                    if (2 == eventType) {
                        if (newValue instanceof Element) {
                            Element e = (Element)newValue;
                            if (SSESyncResource.this.doc.getDocumentElement().equals(e)) {
                                DocumentAdapter existingDocAdapter = (DocumentAdapter)EcoreUtil.getExistingAdapter((Notifier)SSESyncResource.this.pomModel, DocumentAdapter.class);
                                if (existingDocAdapter != null) {
                                    SSESyncResource.this.pomModel.eAdapters().remove((Object)existingDocAdapter);
                                }
                                SSESyncResource.this.createAdapterForRootNode(e).load();
                            }
                        }
                    } else if (3 == eventType && changedFeature instanceof Element) {
                        DocumentAdapter existingDocAdapter;
                        ModelObjectAdapter existing = (ModelObjectAdapter)EcoreUtil.getExistingAdapter((Notifier)SSESyncResource.this.pomModel, ModelObjectAdapter.class);
                        if (existing != null) {
                            SSESyncResource.this.pomModel.eAdapters().remove((Object)existing);
                        }
                        if (SSESyncResource.this.doc.getDocumentElement() == null) {
                            for (EStructuralFeature feature : SSESyncResource.this.pomModel.eClass().getEStructuralFeatures()) {
                                SSESyncResource.this.pomModel.eUnset(feature);
                            }
                        }
                        if ((existingDocAdapter = (DocumentAdapter)EcoreUtil.getExistingAdapter((Notifier)SSESyncResource.this.pomModel, DocumentAdapter.class)) == null) {
                            SSESyncResource.this.pomModel.eAdapters().add((Object)this);
                        }
                    }
                }
                finally {
                    SSESyncResource.this.setProcessEvents(true);
                }
            }
        }

        public Notifier getTarget() {
            return this.target;
        }

        public void setTarget(Notifier newTarget) {
            this.target = newTarget;
        }
    }
}

