/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.target;

import java.util.Collection;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.m2e.pde.target.shared.DependencyDepth;

public class MavenTargetDependencyFilter
implements DependencyFilter {
    private static final String[] VALID_EXTENSIONS = new String[]{"jar", "pom"};
    private Collection<String> locationScopes;
    private DependencyDepth dependencyDepth;

    public MavenTargetDependencyFilter(DependencyDepth dependencyDepth, Collection<String> dependencyScopes) {
        this.dependencyDepth = dependencyDepth;
        this.locationScopes = dependencyScopes;
    }

    public boolean accept(DependencyNode node, List<DependencyNode> parents) {
        String extension = node.getArtifact().getExtension();
        String[] stringArray = VALID_EXTENSIONS;
        int n = VALID_EXTENSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String valid = stringArray[n2];
            if (valid.equalsIgnoreCase(extension) && (this.dependencyDepth == DependencyDepth.INFINITE || this.dependencyDepth == DependencyDepth.DIRECT && parents.size() <= 1)) {
                Dependency dependency = node.getDependency();
                if (dependency == null) {
                    Artifact artifact = node.getArtifact();
                    if (artifact == null) {
                        return false;
                    }
                    dependency = new Dependency(artifact, null);
                }
                return this.isValidScope(dependency);
            }
            ++n2;
        }
        return false;
    }

    private boolean isValidScope(Dependency dependency) {
        String dependecyScope = dependency.getScope();
        if (dependecyScope == null || dependecyScope.isBlank()) {
            return true;
        }
        if (this.locationScopes.isEmpty()) {
            return "compile".equalsIgnoreCase(dependecyScope);
        }
        return this.locationScopes.stream().anyMatch(dependecyScope::equalsIgnoreCase);
    }

    static final Collection<String> expandScope(String scope) {
        if (scope == null || scope.isBlank() || "compile".equalsIgnoreCase(scope)) {
            return List.of("compile");
        }
        if ("provided".equalsIgnoreCase(scope)) {
            return List.of("provided", "compile", "system", "runtime");
        }
        if ("test".equalsIgnoreCase(scope)) {
            return List.of("test", "compile", "provided", "system", "runtime");
        }
        return List.of();
    }
}

