/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.embedder;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.cli.configuration.SettingsXmlConfigurationProcessor;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.lifecycle.internal.LifecycleExecutionPlanCalculator;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.version.DefaultPluginVersionRequest;
import org.apache.maven.plugin.version.PluginVersionRequest;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.plugin.version.PluginVersionResolver;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.project.ProjectSorter;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsUtils;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.DefaultSettingsProblem;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.apache.maven.settings.io.SettingsWriter;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.converters.lookup.DefaultConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.IComponentLookup;
import org.eclipse.m2e.core.embedder.ILocalRepositoryListener;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.embedder.IMavenConfigurationChangeListener;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.embedder.ISettingsChangeListener;
import org.eclipse.m2e.core.embedder.MavenConfigurationChangeEvent;
import org.eclipse.m2e.core.embedder.MavenSettingsLocations;
import org.eclipse.m2e.core.internal.M2EUtils;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.embedder.MavenExecutionContext;
import org.eclipse.m2e.core.internal.embedder.PlexusContainerManager;
import org.eclipse.m2e.internal.maven.compat.LifecycleExecutionPlanCalculatorFacade;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={IMaven.class, IMavenConfigurationChangeListener.class})
public class MavenImpl
implements IMaven,
IMavenConfigurationChangeListener {
    private static final Logger log = LoggerFactory.getLogger(MavenImpl.class);
    @Reference
    private IMavenConfiguration mavenConfiguration;
    private final ConverterLookup converterLookup = new DefaultConverterLookup();
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final List<ISettingsChangeListener> settingsListeners = new CopyOnWriteArrayList<ISettingsChangeListener>();
    private final List<ILocalRepositoryListener> localRepositoryListeners = new ArrayList<ILocalRepositoryListener>();
    @Reference
    private PlexusContainerManager containerManager;
    private Map<MavenSettingsLocations, MavenSettings> settingsCacheMap = new ConcurrentHashMap<MavenSettingsLocations, MavenSettings>();
    private static final char PATH_SEPARATOR = '/';
    private static final char GROUP_SEPARATOR = '.';

    @Override
    public String getLocalRepositoryPath() {
        String path = null;
        try {
            path = this.getSettings().getLocalRepository();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (path == null) {
            path = RepositorySystem.defaultUserLocalRepository.getAbsolutePath();
        }
        return path;
    }

    IMavenConfiguration getMavenConfiguration() {
        return this.mavenConfiguration;
    }

    @Override
    public <T> T getConfiguredMojo(MavenSession session, MojoExecution mojoExecution, Class<T> clazz) throws CoreException {
        try {
            MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
            this.lookup((Class<T>)BuildPluginManager.class).getPluginRealm(session, mojoDescriptor.getPluginDescriptor());
            return clazz.cast(this.lookup((Class<T>)MavenPluginManager.class).getConfiguredMojo(Mojo.class, session, mojoExecution));
        }
        catch (ClassCastException | PluginConfigurationException | PluginManagerException | PluginResolutionException ex) {
            throw new CoreException(Status.error((String)NLS.bind((String)Messages.MavenImpl_error_mojo, (Object)mojoExecution), (Throwable)ex));
        }
    }

    @Override
    public void releaseMojo(Object mojo, MojoExecution mojoExecution) throws CoreException {
        this.lookup((Class<T>)MavenPluginManager.class).releaseMojo(mojo, mojoExecution);
    }

    private MavenExecutionPlan calculateExecutionPlan(MavenSession session, List<String> goals, boolean setup) throws CoreException {
        try {
            return this.lookup((Class<T>)LifecycleExecutor.class).calculateExecutionPlan(session, setup, (String[])goals.toArray(String[]::new));
        }
        catch (Exception ex) {
            throw new CoreException(Status.error((String)NLS.bind((String)Messages.MavenImpl_error_calc_build_plan, (Object)ex.getMessage()), (Throwable)ex));
        }
    }

    @Override
    public MavenExecutionPlan calculateExecutionPlan(MavenProject project, List<String> goals, boolean setup, IProgressMonitor monitor) throws CoreException {
        return this.getExecutionContext().execute(project, (IMavenExecutionContext context, IProgressMonitor pm) -> this.calculateExecutionPlan(context.getSession(), goals, setup), monitor);
    }

    private MojoExecution setupMojoExecution(MavenSession session, MavenProject project, MojoExecution execution) throws CoreException {
        MojoExecution clone = new MojoExecution(execution.getPlugin(), execution.getGoal(), execution.getExecutionId());
        clone.setMojoDescriptor(execution.getMojoDescriptor());
        if (execution.getConfiguration() != null) {
            clone.setConfiguration(new Xpp3Dom(execution.getConfiguration()));
        }
        clone.setLifecyclePhase(execution.getLifecyclePhase());
        LifecycleExecutionPlanCalculatorFacade executionPlanCalculator = new LifecycleExecutionPlanCalculatorFacade(this.lookup((Class<T>)LifecycleExecutionPlanCalculator.class));
        try {
            executionPlanCalculator.setupMojoExecution(session, project, clone);
        }
        catch (Exception ex) {
            throw new CoreException(Status.error((String)NLS.bind((String)Messages.MavenImpl_error_calc_build_plan, (Object)ex.getMessage()), (Throwable)ex));
        }
        return clone;
    }

    @Override
    public MojoExecution setupMojoExecution(MavenProject project, MojoExecution execution, IProgressMonitor monitor) throws CoreException {
        return this.getExecutionContext().execute(project, (IMavenExecutionContext context, IProgressMonitor pm) -> this.setupMojoExecution(context.getSession(), project, execution), monitor);
    }

    @Override
    public ArtifactRepository getLocalRepository() throws CoreException {
        try {
            String localRepositoryPath = this.getLocalRepositoryPath();
            if (localRepositoryPath != null) {
                return this.lookup((Class<T>)RepositorySystem.class).createLocalRepository(new File(localRepositoryPath));
            }
            return this.lookup((Class<T>)RepositorySystem.class).createLocalRepository(RepositorySystem.defaultUserLocalRepository);
        }
        catch (InvalidRepositoryException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public Settings getSettings() throws CoreException {
        return this.getSettings(this.mavenConfiguration.getSettingsLocations());
    }

    @Override
    public Settings getSettings(MavenSettingsLocations locations) throws CoreException {
        MavenSettings cache = this.settingsCacheMap.computeIfAbsent(locations, key -> new MavenSettings((MavenSettingsLocations)key, this));
        return cache.getSettings();
    }

    @Override
    public Settings buildSettings(String globalSettings, String userSettings) throws CoreException {
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        request.setGlobalSettingsFile(globalSettings != null ? new File(globalSettings) : null);
        request.setUserSettingsFile(userSettings != null ? new File(userSettings) : SettingsXmlConfigurationProcessor.DEFAULT_USER_SETTINGS_FILE);
        try {
            return this.lookup((Class<T>)SettingsBuilder.class).build((SettingsBuildingRequest)request).getEffectiveSettings();
        }
        catch (SettingsBuildingException ex) {
            throw new CoreException(Status.error((String)Messages.MavenImpl_error_read_settings, (Throwable)ex));
        }
    }

    @Override
    public void writeSettings(Settings settings, OutputStream out) throws CoreException {
        try {
            this.lookup((Class<T>)SettingsWriter.class).write(out, null, settings);
        }
        catch (IOException ex) {
            throw new CoreException(Status.error((String)Messages.MavenImpl_error_write_settings, (Throwable)ex));
        }
    }

    @Override
    public List<SettingsProblem> validateSettings(String settings) {
        ArrayList<SettingsProblem> problems = new ArrayList<SettingsProblem>();
        if (settings != null) {
            File settingsFile = new File(settings);
            if (settingsFile.canRead()) {
                DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
                request.setUserSettingsFile(settingsFile);
                try {
                    this.lookup((Class<T>)SettingsBuilder.class).build((SettingsBuildingRequest)request);
                }
                catch (SettingsBuildingException ex) {
                    problems.addAll(ex.getProblems());
                }
                catch (CoreException ex) {
                    problems.add((SettingsProblem)new DefaultSettingsProblem(ex.getMessage(), SettingsProblem.Severity.FATAL, settings, -1, -1, (Exception)((Object)ex)));
                }
            } else {
                problems.add((SettingsProblem)new DefaultSettingsProblem(NLS.bind((String)Messages.MavenImpl_error_read_settings2, (Object)settings), SettingsProblem.Severity.ERROR, settings, -1, -1, null));
            }
        }
        return problems;
    }

    @Override
    public void reloadSettings() throws CoreException {
        this.settingsCacheMap.clear();
        Settings reloadedSettings = this.getSettings(this.mavenConfiguration.getSettingsLocations());
        for (ISettingsChangeListener listener : this.settingsListeners) {
            try {
                listener.settingsChanged(reloadedSettings);
            }
            catch (CoreException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public Server decryptPassword(Server server) throws CoreException {
        DefaultSettingsDecryptionRequest request = new DefaultSettingsDecryptionRequest(server);
        SettingsDecryptionResult result = this.lookup((Class<T>)SettingsDecrypter.class).decrypt((SettingsDecryptionRequest)request);
        for (SettingsProblem problem : result.getProblems()) {
            log.warn(problem.getMessage(), (Throwable)problem.getException());
        }
        return result.getServer();
    }

    @Override
    public void mavenConfigurationChange(MavenConfigurationChangeEvent event) throws CoreException {
        if ("eclipse.m2.userSettingsFile".equals(event.key()) || "eclipse.m2.globalSettingsFile".equals(event.key())) {
            this.reloadSettings();
        }
    }

    @Override
    public MavenProject readProject(File pomFile, IProgressMonitor monitor) throws CoreException {
        return this.getExecutionContext().execute((context, pm) -> {
            MavenExecutionRequest request = DefaultMavenExecutionRequest.copy((MavenExecutionRequest)context.getExecutionRequest());
            try {
                this.lookup((Class<T>)MavenExecutionRequestPopulator.class).populateDefaults(request);
                ProjectBuildingRequest configuration = request.getProjectBuildingRequest();
                configuration.setValidationLevel(0);
                configuration.setRepositorySession((RepositorySystemSession)MavenExecutionContext.createRepositorySession(request, this.getMavenConfiguration(), this));
                return this.lookup((Class<T>)ProjectBuilder.class).build(pomFile, configuration).getProject();
            }
            catch (MavenExecutionRequestPopulationException | ProjectBuildingException ex) {
                throw new CoreException(Status.error((String)Messages.MavenImpl_error_read_project, (Throwable)ex));
            }
        }, monitor);
    }

    private IMavenExecutionContext getExecutionContext() {
        return IMavenExecutionContext.getThreadContext().orElseGet(this::createExecutionContext);
    }

    @Override
    public MavenExecutionResult readMavenProject(File pomFile, ProjectBuildingRequest configuration) throws CoreException {
        long start = System.currentTimeMillis();
        log.debug("Reading Maven project: {}", (Object)pomFile.getAbsoluteFile());
        DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
        try {
            try {
                configuration.setValidationLevel(0);
                ProjectBuildingResult projectBuildingResult = this.lookup((Class<T>)ProjectBuilder.class).build(pomFile, configuration);
                result.setProject(projectBuildingResult.getProject());
                result.setDependencyResolutionResult(projectBuildingResult.getDependencyResolutionResult());
            }
            catch (ProjectBuildingException ex) {
                if (ex.getResults() != null && ex.getResults().size() == 1) {
                    ProjectBuildingResult projectBuildingResult = (ProjectBuildingResult)ex.getResults().get(0);
                    result.setProject(projectBuildingResult.getProject());
                    result.setDependencyResolutionResult(projectBuildingResult.getDependencyResolutionResult());
                }
                result.addException((Throwable)ex);
                log.debug("Read Maven project: {} in {} ms", (Object)pomFile.getAbsoluteFile(), (Object)(System.currentTimeMillis() - start));
            }
            catch (RuntimeException e) {
                result.addException((Throwable)e);
                log.debug("Read Maven project: {} in {} ms", (Object)pomFile.getAbsoluteFile(), (Object)(System.currentTimeMillis() - start));
            }
        }
        finally {
            log.debug("Read Maven project: {} in {} ms", (Object)pomFile.getAbsoluteFile(), (Object)(System.currentTimeMillis() - start));
        }
        return result;
    }

    @Override
    public Map<File, MavenExecutionResult> readMavenProjects(Collection<File> pomFiles, ProjectBuildingRequest configuration) throws CoreException {
        LinkedHashMap<File, MavenExecutionResult> result;
        List projectBuildingResults;
        block9: {
            long start = System.currentTimeMillis();
            log.debug("Reading {} Maven project(s): {}", (Object)pomFiles.size(), pomFiles);
            projectBuildingResults = null;
            result = new LinkedHashMap<File, MavenExecutionResult>(pomFiles.size(), 1.0f);
            try {
                try {
                    configuration.setValidationLevel(0);
                    projectBuildingResults = this.lookup((Class<T>)ProjectBuilder.class).build(new ArrayList<File>(pomFiles), false, configuration);
                }
                catch (ProjectBuildingException ex) {
                    if (ex.getResults() != null) {
                        projectBuildingResults = ex.getResults();
                    }
                    log.debug("Read {} Maven project(s) in {} ms", (Object)pomFiles.size(), (Object)(System.currentTimeMillis() - start));
                    break block9;
                }
            }
            catch (Throwable throwable) {
                log.debug("Read {} Maven project(s) in {} ms", (Object)pomFiles.size(), (Object)(System.currentTimeMillis() - start));
                throw throwable;
            }
            log.debug("Read {} Maven project(s) in {} ms", (Object)pomFiles.size(), (Object)(System.currentTimeMillis() - start));
        }
        if (projectBuildingResults != null) {
            for (ProjectBuildingResult projectBuildingResult : projectBuildingResults) {
                DefaultMavenExecutionResult mavenExecutionResult = new DefaultMavenExecutionResult();
                mavenExecutionResult.setProject(projectBuildingResult.getProject());
                mavenExecutionResult.setDependencyResolutionResult(projectBuildingResult.getDependencyResolutionResult());
                if (!projectBuildingResult.getProblems().isEmpty()) {
                    mavenExecutionResult.addException((Throwable)new ProjectBuildingException(Collections.singletonList(projectBuildingResult)));
                }
                result.put(projectBuildingResult.getPomFile(), (MavenExecutionResult)mavenExecutionResult);
            }
        }
        return result;
    }

    @Override
    @Deprecated
    public void detachFromSession(MavenProject project) {
    }

    private MavenProject resolveParentProject(RepositorySystemSession repositorySession, MavenProject child, ProjectBuildingRequest configuration) throws CoreException {
        configuration.setValidationLevel(0);
        configuration.setRepositorySession(repositorySession);
        try {
            configuration.setRemoteRepositories(child.getRemoteArtifactRepositories());
            File parentFile = child.getParentFile();
            if (parentFile == null && child.getParent() != null) {
                parentFile = child.getParent().getFile();
            }
            if (parentFile != null) {
                return this.lookup((Class<T>)ProjectBuilder.class).build(parentFile, configuration).getProject();
            }
            Artifact parentArtifact = child.getParentArtifact();
            if (parentArtifact != null) {
                MavenProject parent = this.lookup((Class<T>)ProjectBuilder.class).build(parentArtifact, configuration).getProject();
                parentFile = parentArtifact.getFile();
                if (parent.getFile() == null) {
                    parent.setFile(parentFile);
                }
                if (parent.getArtifact().getFile() == null) {
                    parent.getArtifact().setFile(parentFile);
                }
                return parent;
            }
        }
        catch (ProjectBuildingException ex) {
            log.error("Could not read parent project", (Throwable)ex);
        }
        return null;
    }

    public MavenProject resolveParentProject(MavenProject child, IProgressMonitor monitor) throws CoreException {
        return this.getExecutionContext().execute(child, (IMavenExecutionContext context, IProgressMonitor pm) -> this.resolveParentProject(context.getRepositorySession(), child, context.getExecutionRequest().getProjectBuildingRequest()), monitor);
    }

    @Override
    public Artifact resolve(String groupId, String artifactId, String version, String type, String classifier, List<ArtifactRepository> remoteRepositories, IProgressMonitor monitor) throws CoreException {
        Artifact artifact = this.lookup((Class<T>)RepositorySystem.class).createArtifactWithClassifier(groupId, artifactId, version, type, classifier);
        return this.resolve(artifact, remoteRepositories, monitor);
    }

    public Artifact resolve(Artifact artifact, List<ArtifactRepository> remoteRepositories, IProgressMonitor monitor) throws CoreException {
        if (remoteRepositories == null) {
            try {
                remoteRepositories = this.getArtifactRepositories();
            }
            catch (CoreException e) {
                remoteRepositories = Collections.emptyList();
            }
        }
        List<ArtifactRepository> repositories = remoteRepositories;
        return this.getExecutionContext().execute((context, pm) -> {
            ArtifactResult result;
            org.eclipse.aether.RepositorySystem repoSystem = this.lookup((Class<T>)org.eclipse.aether.RepositorySystem.class);
            ArtifactRequest request = new ArtifactRequest();
            request.setArtifact(RepositoryUtils.toArtifact((Artifact)artifact));
            request.setRepositories(RepositoryUtils.toRepos((List)repositories));
            try {
                result = repoSystem.resolveArtifact(context.getRepositorySession(), request);
            }
            catch (ArtifactResolutionException ex) {
                result = (ArtifactResult)ex.getResults().get(0);
            }
            this.setLastUpdated(context.getLocalRepository(), repositories, artifact);
            if (!result.isResolved()) {
                ArrayList<IStatus> members = new ArrayList<IStatus>();
                for (Exception e : result.getExceptions()) {
                    if (e instanceof ArtifactNotFoundException) continue;
                    members.add(Status.error((String)e.getMessage(), (Throwable)e));
                }
                if (members.isEmpty()) {
                    members.add(Status.error((String)NLS.bind((String)Messages.MavenImpl_error_missing, (Object)artifact), null));
                }
                IStatus[] newMembers = (IStatus[])members.toArray(IStatus[]::new);
                throw new CoreException((IStatus)new MultiStatus("org.eclipse.m2e.core", -1, newMembers, NLS.bind((String)Messages.MavenImpl_error_resolve, (Object)artifact), null));
            }
            artifact.selectVersion(result.getArtifact().getVersion());
            artifact.setFile(result.getArtifact().getFile());
            artifact.setResolved(true);
            return artifact;
        }, monitor);
    }

    public Artifact resolvePluginArtifact(Plugin plugin, List<ArtifactRepository> remoteRepositories, IProgressMonitor monitor) throws CoreException {
        Artifact artifact = this.lookup((Class<T>)RepositorySystem.class).createPluginArtifact(plugin);
        return this.resolve(artifact, remoteRepositories, monitor);
    }

    @Override
    public String getArtifactPath(ArtifactRepository repository, String groupId, String artifactId, String version, String type, String classifier) throws CoreException {
        Artifact artifact = this.lookup((Class<T>)RepositorySystem.class).createArtifactWithClassifier(groupId, artifactId, version, type, classifier);
        return repository.pathOf(artifact);
    }

    void setLastUpdated(ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, Artifact artifact) throws CoreException {
        Properties lastUpdated = this.loadLastUpdated(localRepository, artifact);
        String timestamp = Long.toString(System.currentTimeMillis());
        for (ArtifactRepository repository : remoteRepositories) {
            lastUpdated.setProperty(this.getLastUpdatedKey(repository, artifact), timestamp);
        }
        File lastUpdatedFile = this.getLastUpdatedFile(localRepository, artifact);
        lastUpdatedFile.getParentFile().mkdirs();
        try {
            Object object = null;
            Object var8_10 = null;
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(lastUpdatedFile));){
                lastUpdated.store(os, null);
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
        }
        catch (IOException ex) {
            throw new CoreException(Status.error((String)Messages.MavenImpl_error_write_lastUpdated, (Throwable)ex));
        }
    }

    @Override
    public boolean isUnavailable(String groupId, String artifactId, String version, String type, String classifier, List<ArtifactRepository> remoteRepositories) throws CoreException {
        Artifact artifact = this.lookup((Class<T>)RepositorySystem.class).createArtifactWithClassifier(groupId, artifactId, version, type, classifier);
        ArtifactRepository localRepository = this.getLocalRepository();
        File artifactFile = new File(localRepository.getBasedir(), localRepository.pathOf(artifact));
        if (artifactFile.canRead()) {
            return false;
        }
        if (remoteRepositories == null || remoteRepositories.isEmpty()) {
            return true;
        }
        Properties lastUpdated = this.loadLastUpdated(localRepository, artifact);
        for (ArtifactRepository repository : remoteRepositories) {
            String timestamp = lastUpdated.getProperty(this.getLastUpdatedKey(repository, artifact));
            if (timestamp != null) continue;
            return false;
        }
        return true;
    }

    private String getLastUpdatedKey(ArtifactRepository repository, Artifact artifact) {
        StringBuilder key = new StringBuilder();
        key.append(repository.getId());
        if (repository.getAuthentication() != null) {
            key.append('|').append(repository.getAuthentication().getUsername());
        }
        key.append('|').append(repository.getUrl());
        key.append('|').append(artifact.getClassifier());
        return key.toString();
    }

    private Properties loadLastUpdated(ArtifactRepository localRepository, Artifact artifact) throws CoreException {
        Properties lastUpdated = new Properties();
        File lastUpdatedFile = this.getLastUpdatedFile(localRepository, artifact);
        try {
            Throwable throwable = null;
            Object var6_9 = null;
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(lastUpdatedFile));){
                lastUpdated.load(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException ex) {
            throw new CoreException(Status.error((String)Messages.MavenImpl_error_read_lastUpdated, (Throwable)ex));
        }
        return lastUpdated;
    }

    private File getLastUpdatedFile(ArtifactRepository localRepository, Artifact artifact) {
        return new File(localRepository.getBasedir(), this.basePathOf(artifact) + "/m2e-lastUpdated.properties");
    }

    private String basePathOf(Artifact artifact) {
        return this.formatAsDirectory(artifact.getGroupId()) + "/" + artifact.getArtifactId() + "/" + artifact.getBaseVersion() + "/";
    }

    private String formatAsDirectory(String directory) {
        return directory.replace('.', '/');
    }

    private <T> T getMojoParameterValue(MavenSession session, MojoExecution mojoExecution, List<String> parameterPath, Class<T> asType) throws CoreException {
        Xpp3Dom dom = mojoExecution.getConfiguration();
        if (dom == null) {
            return null;
        }
        XmlPlexusConfiguration configuration = new XmlPlexusConfiguration(dom);
        for (String parameter : parameterPath) {
            if ((configuration = configuration.getChild(parameter)) != null) continue;
            return null;
        }
        return this.getMojoParameterValue(session, mojoExecution, (PlexusConfiguration)configuration, asType, String.join((CharSequence)"/", parameterPath));
    }

    private <T> T getMojoParameterValue(MavenSession session, MojoExecution mojoExecution, PlexusConfiguration configuration, Class<T> asType, String parameterLabel) throws CoreException {
        try {
            MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
            ClassRealm pluginRealm = this.lookup((Class<T>)BuildPluginManager.class).getPluginRealm(session, mojoDescriptor.getPluginDescriptor());
            PluginParameterExpressionEvaluator expressionEvaluator = new PluginParameterExpressionEvaluator(session, mojoExecution);
            ConfigurationConverter typeConverter = this.converterLookup.lookupConverterForType(asType);
            Object value = typeConverter.fromConfiguration(this.converterLookup, configuration, asType, mojoDescriptor.getImplementationClass(), (ClassLoader)pluginRealm, (ExpressionEvaluator)expressionEvaluator, null);
            return asType.cast(value);
        }
        catch (Exception e) {
            throw new CoreException(Status.error((String)NLS.bind((String)Messages.MavenImpl_error_param_for_execution, (Object)parameterLabel, (Object)mojoExecution.getExecutionId()), (Throwable)e));
        }
    }

    @Override
    public <T> T getMojoParameterValue(MavenProject project, MojoExecution mojoExecution, String parameter, Class<T> asType, IProgressMonitor monitor) throws CoreException {
        return (T)this.getExecutionContext().execute(project, (IMavenExecutionContext context, IProgressMonitor pm) -> this.getMojoParameterValue(context.getSession(), mojoExecution, List.of(parameter), asType), monitor);
    }

    public <T> T getMojoParameterValue(MavenProject project, MojoExecution mojoExecution, List<String> parameterPath, Class<T> asType, IProgressMonitor monitor) throws CoreException {
        return (T)this.getExecutionContext().execute(project, (IMavenExecutionContext context, IProgressMonitor pm) -> this.getMojoParameterValue(context.getSession(), mojoExecution, parameterPath, asType), monitor);
    }

    private <T> T getMojoParameterValue(String parameter, Class<T> type, MavenSession session, Plugin plugin, ConfigurationContainer configuration, String goal) throws CoreException {
        Xpp3Dom config = (Xpp3Dom)configuration.getConfiguration();
        config = config != null ? config.getChild(parameter) : null;
        XmlPlexusConfiguration paramConfig = null;
        if (config == null) {
            MojoDescriptor mojoDescriptor;
            try {
                mojoDescriptor = this.lookup((Class<T>)BuildPluginManager.class).getMojoDescriptor(plugin, goal, session.getCurrentProject().getRemotePluginRepositories(), session.getRepositorySession());
            }
            catch (InvalidPluginDescriptorException | MojoNotFoundException | PluginDescriptorParsingException | PluginNotFoundException | PluginResolutionException ex) {
                throw new CoreException(Status.error((String)Messages.MavenImpl_error_param, (Throwable)ex));
            }
            PlexusConfiguration defaultConfig = mojoDescriptor.getMojoConfiguration();
            if (defaultConfig != null) {
                paramConfig = defaultConfig.getChild(parameter, false);
            }
        } else {
            paramConfig = new XmlPlexusConfiguration(config);
        }
        if (paramConfig == null) {
            return null;
        }
        try {
            MojoExecution mojoExecution = new MojoExecution(plugin, goal, "default");
            PluginParameterExpressionEvaluator expressionEvaluator = new PluginParameterExpressionEvaluator(session, mojoExecution);
            ConfigurationConverter typeConverter = this.converterLookup.lookupConverterForType(type);
            Object value = typeConverter.fromConfiguration(this.converterLookup, (PlexusConfiguration)paramConfig, type, Object.class, (ClassLoader)this.getPlexusContainer().getContainerRealm(), (ExpressionEvaluator)expressionEvaluator, null);
            return type.cast(value);
        }
        catch (ClassCastException | ComponentConfigurationException ex) {
            throw new CoreException(Status.error((String)Messages.MavenImpl_error_param, (Throwable)ex));
        }
    }

    @Override
    public <T> T getMojoParameterValue(MavenProject project, String parameter, Class<T> type, Plugin plugin, ConfigurationContainer configuration, String goal, IProgressMonitor monitor) throws CoreException {
        return (T)this.getExecutionContext().execute(project, (IMavenExecutionContext context, IProgressMonitor pm) -> this.getMojoParameterValue(parameter, type, context.getSession(), plugin, configuration, goal), monitor);
    }

    @Override
    public ArtifactRepository createArtifactRepository(String id, String url) throws CoreException {
        ArtifactRepository repo;
        Repository repository = new Repository();
        repository.setId(id);
        repository.setUrl(url);
        repository.setLayout("default");
        try {
            repo = this.lookup((Class<T>)RepositorySystem.class).buildArtifactRepository(repository);
            ArrayList<ArtifactRepository> repos = new ArrayList<ArtifactRepository>(Arrays.asList(repo));
            this.injectSettings(repos);
        }
        catch (InvalidRepositoryException ex) {
            throw new CoreException(Status.error((String)Messages.MavenImpl_error_create_repo, (Throwable)ex));
        }
        return repo;
    }

    @Override
    public List<ArtifactRepository> getArtifactRepositories() throws CoreException {
        return this.getArtifactRepositories(true);
    }

    @Override
    public List<ArtifactRepository> getArtifactRepositories(boolean injectSettings) throws CoreException {
        ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>();
        for (org.apache.maven.model.Profile profile : this.getActiveProfiles()) {
            this.addArtifactRepositories(repositories, profile.getRepositories());
        }
        this.addDefaultRepository(repositories);
        if (injectSettings) {
            this.injectSettings(repositories);
        }
        return this.removeDuplicateRepositories(repositories);
    }

    private List<ArtifactRepository> removeDuplicateRepositories(List<ArtifactRepository> repositories) {
        ArrayList<ArtifactRepository> result = new ArrayList<ArtifactRepository>();
        HashSet<String> keys = new HashSet<String>();
        for (ArtifactRepository repository : repositories) {
            StringBuilder key = new StringBuilder();
            if (repository.getId() != null) {
                key.append(repository.getId());
            }
            key.append(':').append(repository.getUrl()).append(':');
            if (repository.getAuthentication() != null && repository.getAuthentication().getUsername() != null) {
                key.append(repository.getAuthentication().getUsername());
            }
            if (!keys.add(key.toString())) continue;
            result.add(repository);
        }
        return result;
    }

    private void injectSettings(List<ArtifactRepository> repositories) throws CoreException {
        Settings setting = this.getSettings();
        RepositorySystem repositorySystem = this.lookup((Class<T>)RepositorySystem.class);
        repositorySystem.injectMirror(repositories, this.getMirrors());
        repositorySystem.injectProxy(repositories, setting.getProxies());
        repositorySystem.injectAuthentication(repositories, setting.getServers());
    }

    private void addDefaultRepository(List<ArtifactRepository> repositories) throws CoreException {
        if (repositories.stream().noneMatch(r -> "central".equals(r.getId()))) {
            try {
                repositories.add(0, this.lookup((Class<T>)RepositorySystem.class).createDefaultRemoteRepository());
            }
            catch (InvalidRepositoryException ex) {
                log.error("Unexpected exception", (Throwable)ex);
            }
        }
    }

    private void addArtifactRepositories(List<ArtifactRepository> artifactRepositories, List<Repository> repositories) throws CoreException {
        for (Repository repository : repositories) {
            try {
                ArtifactRepository artifactRepository = this.lookup((Class<T>)RepositorySystem.class).buildArtifactRepository(repository);
                artifactRepositories.add(artifactRepository);
            }
            catch (InvalidRepositoryException ex) {
                throw new CoreException(Status.error((String)Messages.MavenImpl_error_read_settings, (Throwable)ex));
            }
        }
    }

    private List<org.apache.maven.model.Profile> getActiveProfiles() throws CoreException {
        Settings setting = this.getSettings();
        List activeProfilesIds = setting.getActiveProfiles();
        ArrayList<org.apache.maven.model.Profile> activeProfiles = new ArrayList<org.apache.maven.model.Profile>();
        for (Profile settingsProfile : setting.getProfiles()) {
            if ((settingsProfile.getActivation() == null || !settingsProfile.getActivation().isActiveByDefault()) && !activeProfilesIds.contains(settingsProfile.getId())) continue;
            org.apache.maven.model.Profile profile = SettingsUtils.convertFromSettingsProfile((Profile)settingsProfile);
            activeProfiles.add(profile);
        }
        return activeProfiles;
    }

    @Override
    public List<ArtifactRepository> getPluginArtifactRepositories() throws CoreException {
        return this.getPluginArtifactRepositories(true);
    }

    @Override
    public List<ArtifactRepository> getPluginArtifactRepositories(boolean injectSettings) throws CoreException {
        ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>();
        for (org.apache.maven.model.Profile profile : this.getActiveProfiles()) {
            this.addArtifactRepositories(repositories, profile.getPluginRepositories());
        }
        this.addDefaultRepository(repositories);
        if (injectSettings) {
            this.injectSettings(repositories);
        }
        return this.removeDuplicateRepositories(repositories);
    }

    @Override
    public Mirror getMirror(ArtifactRepository repo) throws CoreException {
        return this.getExecutionContext().execute((c, m) -> this.lookup((Class<T>)RepositorySystem.class).getMirror(repo, c.getExecutionRequest().getMirrors()), null);
    }

    @Override
    public List<Mirror> getMirrors() throws CoreException {
        return this.getExecutionContext().execute((c, m) -> c.getExecutionRequest().getMirrors(), null);
    }

    @Override
    public void addLocalRepositoryListener(ILocalRepositoryListener listener) {
        this.localRepositoryListeners.add(listener);
    }

    @Override
    public void removeLocalRepositoryListener(ILocalRepositoryListener listener) {
        this.localRepositoryListeners.remove(listener);
    }

    public List<ILocalRepositoryListener> getLocalRepositoryListeners() {
        return this.localRepositoryListeners;
    }

    public PlexusContainer getPlexusContainer() throws CoreException {
        try {
            return this.containerManager.aquire().getContainer();
        }
        catch (Exception ex) {
            throw new CoreException(Status.error((String)Messages.MavenImpl_error_init_maven, (Throwable)ex));
        }
    }

    @Override
    public ProxyInfo getProxyInfo(String protocol) throws CoreException {
        for (Proxy proxy : this.getSettings().getProxies()) {
            if (!proxy.isActive() || !protocol.equalsIgnoreCase(proxy.getProtocol())) continue;
            ProxyInfo proxyInfo = new ProxyInfo();
            proxyInfo.setType(proxy.getProtocol());
            proxyInfo.setHost(proxy.getHost());
            proxyInfo.setPort(proxy.getPort());
            proxyInfo.setNonProxyHosts(proxy.getNonProxyHosts());
            proxyInfo.setUserName(proxy.getUsername());
            proxyInfo.setPassword(proxy.getPassword());
            return proxyInfo;
        }
        return null;
    }

    @Override
    public List<MavenProject> getSortedProjects(List<MavenProject> projects) throws CoreException {
        try {
            ProjectSorter rm = new ProjectSorter(projects);
            return rm.getSortedProjects();
        }
        catch (DuplicateProjectException | CycleDetectedException ex) {
            throw new CoreException(Status.error((String)Messages.MavenImpl_error_sort, (Throwable)ex));
        }
    }

    @Override
    public String resolvePluginVersion(String groupId, String artifactId, MavenSession session) throws CoreException {
        Plugin plugin = new Plugin();
        plugin.setGroupId(groupId);
        plugin.setArtifactId(artifactId);
        DefaultPluginVersionRequest request = new DefaultPluginVersionRequest(plugin, session);
        try {
            return this.lookup((Class<T>)PluginVersionResolver.class).resolve((PluginVersionRequest)request).getVersion();
        }
        catch (PluginVersionResolutionException ex) {
            throw new CoreException(Status.error((String)ex.getMessage(), (Throwable)ex));
        }
    }

    public <T> T lookup(Class<T> clazz) throws CoreException {
        if (clazz == PlexusContainerManager.class) {
            return clazz.cast(this.containerManager);
        }
        if (clazz == PlexusContainer.class) {
            return clazz.cast(this.getPlexusContainer());
        }
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            PlexusContainer plexusContainer = this.getPlexusContainer();
            Thread.currentThread().setContextClassLoader((ClassLoader)plexusContainer.getContainerRealm());
            Object object = plexusContainer.lookup(clazz);
            return (T)object;
        }
        catch (ComponentLookupException ex) {
            throw new CoreException(Status.error((String)Messages.MavenImpl_error_lookup, (Throwable)ex));
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    @Override
    public <C> Collection<C> lookupCollection(Class<C> type) throws CoreException {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            PlexusContainer plexusContainer = this.getPlexusContainer();
            Thread.currentThread().setContextClassLoader((ClassLoader)plexusContainer.getContainerRealm());
            List list = plexusContainer.lookupList(type);
            return list;
        }
        catch (ComponentLookupException ex) {
            List list = List.of();
            return list;
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    @Override
    public ClassLoader getProjectRealm(MavenProject project) {
        Objects.requireNonNull(project);
        ClassRealm classLoader = project.getClassRealm();
        if (classLoader == null) {
            try {
                return this.containerManager.aquire(project.getBasedir()).getContainer().getContainerRealm();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return classLoader;
    }

    public void interpolateModel(MavenProject project, Model model) throws CoreException {
        DefaultModelBuildingRequest request = new DefaultModelBuildingRequest();
        request.setUserProperties(project.getProperties());
        this.lookup((Class<T>)ModelInterpolator.class).interpolateModel(model, project.getBasedir(), (ModelBuildingRequest)request, req -> {});
    }

    public static <V> V execute(IMaven maven, boolean offline, boolean forceDependencyUpdate, ICallable<V> callable, IProgressMonitor monitor) throws CoreException {
        IMavenExecutionContext context = maven.createExecutionContext();
        context.getExecutionRequest().setOffline(offline);
        context.getExecutionRequest().setUpdateSnapshots(forceDependencyUpdate);
        return context.execute(callable, monitor);
    }

    @Override
    public MavenExecutionContext createExecutionContext() {
        return new MavenExecutionContext(this, null, null);
    }

    private static final class MavenSettings {
        private long userSettingsLength;
        private long userSettingsTimestamp;
        private long globalSettingsLength;
        private long globalSettingsTimestamp;
        private MavenSettingsLocations locations;
        private Settings settings;
        private IComponentLookup lookup;

        public MavenSettings(MavenSettingsLocations locations, IComponentLookup lookup) {
            this.locations = locations;
            this.lookup = lookup;
        }

        private synchronized Settings getSettings() throws CoreException {
            boolean reload;
            long ut;
            long us;
            long gt;
            long gs;
            File global = this.locations.globalSettings();
            if (global != null && global.isFile()) {
                gs = global.length();
                gt = global.lastModified();
            } else {
                gs = -1L;
                gt = -1L;
            }
            File user = this.locations.userSettings();
            if (user != null && user.isFile()) {
                us = user.length();
                ut = user.lastModified();
            } else {
                us = -1L;
                ut = -1L;
            }
            boolean bl = reload = this.settings == null || gs != this.globalSettingsLength || gt != this.globalSettingsTimestamp || us != this.userSettingsLength || ut != this.userSettingsTimestamp;
            if (reload) {
                DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
                Properties systemProperties = new Properties();
                M2EUtils.copyProperties(systemProperties, System.getProperties());
                request.setSystemProperties(systemProperties);
                if (global != null) {
                    request.setGlobalSettingsFile(global);
                }
                if (user != null) {
                    request.setUserSettingsFile(user);
                }
                try {
                    this.settings = this.lookup.lookup(SettingsBuilder.class).build((SettingsBuildingRequest)request).getEffectiveSettings();
                }
                catch (SettingsBuildingException ex) {
                    log.error("Could not read settingsCacheMap.xml, assuming default values", (Throwable)ex);
                    this.settings = new Settings();
                }
                this.globalSettingsLength = gs;
                this.globalSettingsTimestamp = gt;
                this.userSettingsLength = us;
                this.userSettingsTimestamp = ut;
            }
            return this.settings;
        }
    }
}

