/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.logback.appender;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.core.ui.internal.console.MavenConsoleImpl;
import org.osgi.framework.Bundle;

public class MavenConsoleAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final String M2E_CORE_UI_BUNDLE_ID = "org.eclipse.m2e.core.ui";
    private Bundle m2eCoreUIBundle;

    protected void append(ILoggingEvent logEvent) {
        if (!this.isActive()) {
            return;
        }
        MavenConsoleAppenderImpl.appendToMavenConsole(logEvent);
    }

    private boolean isActive() {
        if (this.m2eCoreUIBundle == null) {
            this.m2eCoreUIBundle = Platform.getBundle((String)M2E_CORE_UI_BUNDLE_ID);
            if (this.m2eCoreUIBundle == null) {
                System.out.println("Could not find org.eclipse.m2e.core.ui bundle.");
                return false;
            }
        }
        return this.m2eCoreUIBundle.getState() == 32;
    }

    private static class MavenConsoleAppenderImpl {
        private MavenConsoleAppenderImpl() {
        }

        public static void appendToMavenConsole(ILoggingEvent logEvent) {
            M2EUIPluginActivator uiPlugin = M2EUIPluginActivator.getDefault();
            if (!uiPlugin.hasMavenConsoleImpl()) {
                return;
            }
            MavenConsoleImpl mavenConsole = uiPlugin.getMavenConsole();
            switch (logEvent.getLevel().levelInt) {
                case 10000: {
                    mavenConsole.debug(logEvent.toString());
                    return;
                }
                case 40000: {
                    mavenConsole.error(logEvent.toString());
                    return;
                }
            }
            mavenConsole.info(logEvent.toString());
        }
    }
}

