/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.svn.core.IProjectSetHandler;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.remote.CheckoutAsOperation;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class DefaultProjectSetHandler
implements IProjectSetHandler {
    protected static final String PLUGIN_INFORMATION = "1.0.1";

    public String getProjectNameForReference(String fullReference) {
        String[] parts = fullReference.split(",");
        if (parts.length < 3 || !parts[0].equals(PLUGIN_INFORMATION)) {
            return null;
        }
        return parts[2];
    }

    public String asReference(IProject project) throws TeamException {
        IRepositoryResource resource = SVNRemoteStorage.instance().asRepositoryResource((IResource)project);
        IRepositoryLocation location = resource.getRepositoryLocation();
        String fullReference = PLUGIN_INFORMATION;
        fullReference = String.valueOf(fullReference) + "," + resource.getUrl();
        fullReference = String.valueOf(fullReference) + "," + project.getName();
        fullReference = String.valueOf(fullReference) + "," + SVNRemoteStorage.instance().repositoryLocationAsReference(location, IRepositoryLocation.LocationReferenceTypeEnum.WITHOUT_REVISION_COMMENTS);
        return fullReference;
    }

    public String asReference(String resourceUrl, String projectName) {
        String fullReference = PLUGIN_INFORMATION;
        fullReference = String.valueOf(fullReference) + "," + resourceUrl;
        fullReference = String.valueOf(fullReference) + "," + projectName;
        return fullReference;
    }

    public IProject configureCheckoutOperation(CompositeOperation op, IProject project, String fullReference) throws TeamException {
        String[] parts = fullReference.split(",");
        IRepositoryLocation location = this.getLocationForReference(parts);
        IRepositoryContainer resource = location.asRepositoryContainer(parts[1], true);
        if (resource != null) {
            String projectLocation = project.exists() ? FileUtility.getResourcePath((IResource)project).removeLastSegments(1).toString() : Platform.getLocation().toString();
            CheckoutAsOperation mainOp = new CheckoutAsOperation(project.getName(), (IRepositoryResource)resource, projectLocation, SVNDepth.INFINITY, false);
            op.add(mainOp);
            return mainOp.getProject();
        }
        return null;
    }

    protected IRepositoryLocation getLocationForReference(String[] parts) {
        IRepositoryLocation location = null;
        if (parts.length > 3) {
            location = SVNRemoteStorage.instance().newRepositoryLocation(parts[3]);
            if (SVNRemoteStorage.instance().getRepositoryLocation(location.getId()) != null) {
                return location;
            }
        }
        IRepositoryLocation[] locations = SVNRemoteStorage.instance().getRepositoryLocations();
        IPath awaitingFor = SVNUtility.createPathForSVNUrl(location != null ? location.getUrl() : parts[1]);
        int i = 0;
        while (i < locations.length) {
            if (SVNUtility.createPathForSVNUrl(locations[i].getUrl()).isPrefixOf(awaitingFor)) {
                return locations[i];
            }
            ++i;
        }
        if (location == null) {
            location = SVNRemoteStorage.instance().newRepositoryLocation();
            location.setUrl(parts[1]);
        }
        SVNRemoteStorage.instance().addRepositoryLocation(location);
        return location;
    }

    public boolean accept(String referenceString) {
        return referenceString.startsWith(PLUGIN_INFORMATION);
    }
}

