/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file.management;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.file.AbstractFileOperation;
import org.eclipse.team.svn.core.operation.file.IFileProvider;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShareOperation
extends AbstractFileOperation {
    public static final int LAYOUT_DEFAULT = 0;
    public static final int LAYOUT_SINGLE = 1;
    public static final int LAYOUT_MULTIPLE = 2;
    protected IRepositoryLocation location;
    protected IFolderNameMapper mapper;
    protected String rootName;
    protected int shareLayout;
    protected boolean managementFoldersEnabled;
    protected String commitComment;
    protected boolean ignoreExternals;

    public ShareOperation(File[] files, IRepositoryLocation location, IFolderNameMapper mapper, String rootName, int shareLayout, boolean managementFoldersEnabled, String commitComment, boolean ignoreExternals) {
        super("Operation_ShareFile", SVNMessages.class, files);
        this.location = location;
        this.mapper = mapper;
        this.rootName = rootName;
        this.shareLayout = shareLayout;
        this.managementFoldersEnabled = managementFoldersEnabled;
        this.commitComment = commitComment;
        this.ignoreExternals = ignoreExternals;
    }

    public ShareOperation(IFileProvider provider, IRepositoryLocation location, IFolderNameMapper mapper, String rootName, int shareLayout, boolean managementFoldersEnabled, String commitComment, boolean ignoreExternals) {
        super("Operation_ShareFile", SVNMessages.class, provider);
        this.location = location;
        this.mapper = mapper;
        this.rootName = rootName;
        this.shareLayout = shareLayout;
        this.managementFoldersEnabled = managementFoldersEnabled;
        this.commitComment = commitComment;
        this.ignoreExternals = ignoreExternals;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File[] folders = FileUtility.shrinkChildNodes(this.operableData(), true);
        HashMap<File, IRepositoryContainer> local2remote = new HashMap<File, IRepositoryContainer>();
        int i = 0;
        while (i < folders.length) {
            String url = this.getTargetUrl(this.mapper == null ? folders[i].getName() : this.mapper.getRepositoryFolderName(folders[i]), this.managementFoldersEnabled);
            IRepositoryContainer remote = this.location.asRepositoryContainer(url, false);
            local2remote.put(folders[i], remote);
            ++i;
        }
        if (this.commitComment == null) {
            this.commitComment = "";
            for (Map.Entry entry : local2remote.entrySet()) {
                String commentPart = ShareOperation.getDefaultComment((File)entry.getKey(), (IRepositoryContainer)entry.getValue());
                this.commitComment = String.valueOf(this.commitComment) + (this.commitComment.length() == 0 ? commentPart : "\n" + commentPart);
            }
        }
        final ISVNConnector proxy = this.location.acquireSVNProxy();
        try {
            block14: {
                Iterator<Map.Entry<File, IRepositoryContainer>> it;
                block13: {
                    IRepositoryResource[] resourceSet = null;
                    switch (this.shareLayout) {
                        case 0: {
                            resourceSet = this.doDefaultLayout(local2remote);
                            break;
                        }
                        case 1: {
                            resourceSet = this.doSingleLayout(local2remote);
                            break;
                        }
                        case 2: {
                            resourceSet = this.doMultipleLayout(local2remote);
                            break;
                        }
                        default: {
                            String message = this.getNationalizedString("Error_UnknownProjectLayoutType");
                            throw new Exception(BaseMessages.format(message, new Object[]{String.valueOf(this.shareLayout)}));
                        }
                    }
                    this.mkdir(proxy, resourceSet, monitor);
                    it = local2remote.entrySet().iterator();
                    if (!true) break block13;
                    if (!it.hasNext()) return;
                    if (monitor.isCanceled()) break block14;
                }
                do {
                    final Map.Entry<File, IRepositoryContainer> entry = it.next();
                    this.protectStep(new IUnprotectedOperation(){

                        public void run(IProgressMonitor monitor) throws Exception {
                            IRepositoryContainer remote = (IRepositoryContainer)entry.getValue();
                            File local = (File)entry.getKey();
                            long options = ShareOperation.this.ignoreExternals ? 1L : 0L;
                            proxy.checkout(SVNUtility.getEntryRevisionReference(remote), local.getAbsolutePath(), SVNDepth.EMPTY, options, new SVNProgressMonitor(ShareOperation.this, monitor, null));
                        }
                    }, monitor, local2remote.size());
                    if (!it.hasNext()) return;
                } while (!monitor.isCanceled());
            }
            return;
        }
        finally {
            this.location.releaseSVNProxy(proxy);
        }
    }

    public static String getDefaultComment(File folder, IRepositoryResource remote) {
        return SVNMessages.format(SVNMessages.Operation_ShareFile_DefaultComment, new String[]{folder.getName(), remote.getUrl()});
    }

    public String getTargetUrl(String projectName, boolean managementFoldersEnabled) {
        return SVNUtility.normalizeURL(this.getTargetUrlImpl(projectName, managementFoldersEnabled));
    }

    protected String getTargetUrlImpl(String projectName, boolean managementFoldersEnabled) {
        String trunkName = managementFoldersEnabled ? "/" + this.getTrunkName() : "";
        switch (this.shareLayout) {
            case 0: {
                return String.valueOf(this.location.getUrl()) + trunkName + "/" + projectName;
            }
            case 1: {
                return String.valueOf(this.location.getUrl()) + "/" + projectName + trunkName;
            }
            case 2: {
                return String.valueOf(this.location.getUrl()) + "/" + this.rootName + trunkName + "/" + projectName;
            }
        }
        String message = this.getNationalizedString("Error_UnknownProjectLayoutType");
        throw new RuntimeException(BaseMessages.format(message, new Object[]{String.valueOf(this.shareLayout)}));
    }

    protected void mkdir(ISVNConnector proxy, IRepositoryResource[] resourceSet, IProgressMonitor monitor) throws Exception {
        ArrayList<String> urlsList = new ArrayList<String>();
        int i = 0;
        while (i < resourceSet.length && !monitor.isCanceled()) {
            ProgressMonitorUtility.setTaskInfo(monitor, this, resourceSet[i].getUrl());
            if (!resourceSet[i].exists()) {
                urlsList.add(SVNUtility.encodeURL(resourceSet[i].getUrl()));
            }
            ProgressMonitorUtility.progress(monitor, -1, resourceSet.length);
            ++i;
        }
        String[] urls = urlsList.toArray(new String[urlsList.size()]);
        proxy.mkdir(urls, this.commitComment, 8L, null, new SVNProgressMonitor(this, monitor, null));
    }

    protected IRepositoryResource[] doDefaultLayout(Map<File, IRepositoryContainer> local2remote) {
        HashSet<IRepositoryResource> fullSet = new HashSet<IRepositoryResource>();
        for (IRepositoryContainer remote : local2remote.values()) {
            IRepositoryResource[] resources = SVNUtility.makeResourceSet(remote.getRepositoryLocation().getRoot(), remote);
            fullSet.addAll(Arrays.asList(resources));
        }
        return this.getOrderedSet(fullSet);
    }

    protected IRepositoryResource[] doSingleLayout(Map<File, IRepositoryContainer> local2remote) {
        if (this.managementFoldersEnabled) {
            HashSet<IRepositoryResource> fullSet = new HashSet<IRepositoryResource>();
            for (IRepositoryContainer remote : local2remote.values()) {
                IRepositoryResource[] resources = SVNUtility.makeResourceSet(remote.getRepositoryLocation().getRoot(), remote);
                fullSet.addAll(Arrays.asList(resources));
                IRepositoryContainer parent = (IRepositoryContainer)remote.getParent();
                fullSet.add(this.makeChild(parent, this.getTagsName()));
                fullSet.add(this.makeChild(parent, this.getBranchesName()));
            }
            return this.getOrderedSet(fullSet);
        }
        return this.doDefaultLayout(local2remote);
    }

    protected IRepositoryResource[] doMultipleLayout(Map<File, IRepositoryContainer> local2remote) {
        if (this.managementFoldersEnabled) {
            HashSet<IRepositoryResource> fullSet = new HashSet<IRepositoryResource>();
            for (IRepositoryContainer remote : local2remote.values()) {
                IRepositoryResource[] resources = SVNUtility.makeResourceSet(remote.getRepositoryLocation().getRoot(), remote);
                fullSet.addAll(Arrays.asList(resources));
                String targetUrl = this.getTargetUrl("", false);
                IRepositoryContainer parent = this.location.asRepositoryContainer(targetUrl, false);
                fullSet.add(this.makeChild(parent, this.getTagsName()));
                fullSet.add(this.makeChild(parent, this.getBranchesName()));
            }
            return this.getOrderedSet(fullSet);
        }
        return this.doDefaultLayout(local2remote);
    }

    protected IRepositoryContainer makeChild(IRepositoryContainer parent, String name) {
        return this.location.asRepositoryContainer(String.valueOf(parent.getUrl()) + "/" + name, false);
    }

    protected IRepositoryResource[] getOrderedSet(Set<IRepositoryResource> fullSet) {
        IRepositoryResource[] resources = fullSet.toArray(new IRepositoryResource[fullSet.size()]);
        Arrays.sort(resources, new Comparator<Object>(){

            @Override
            public int compare(Object arg0, Object arg1) {
                IRepositoryResource first = (IRepositoryResource)arg0;
                IRepositoryResource second = (IRepositoryResource)arg1;
                return first.getUrl().compareTo(second.getUrl());
            }
        });
        return resources;
    }

    protected String getTrunkName() {
        if (this.location.isStructureEnabled()) {
            return this.location.getTrunkLocation();
        }
        return SVNTeamPlugin.instance().getOptionProvider().getDefaultTrunkName();
    }

    protected String getBranchesName() {
        if (this.location.isStructureEnabled()) {
            return this.location.getBranchesLocation();
        }
        return SVNTeamPlugin.instance().getOptionProvider().getDefaultBranchesName();
    }

    protected String getTagsName() {
        if (this.location.isStructureEnabled()) {
            return this.location.getTagsLocation();
        }
        return SVNTeamPlugin.instance().getOptionProvider().getDefaultTagsName();
    }

    public static interface IFolderNameMapper {
        public String getRepositoryFolderName(File var1);
    }
}

