/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AddToSVNOperation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.utility.FileUtility;

public class AddToSVNWithPropertiesOperation
extends AddToSVNOperation {
    protected static final String BINARY_FILE = "application/octet-stream";
    protected static final String TEXT_FILE = "text/plain";
    protected boolean doMarkTextFiles = CoreExtensionsManager.instance().getOptionProvider().isTextMIMETypeRequired();

    public AddToSVNWithPropertiesOperation(IResource[] resources) {
        this(resources, false);
    }

    public AddToSVNWithPropertiesOperation(IResource[] resources, boolean isRecursive) {
        super(resources, isRecursive);
    }

    public AddToSVNWithPropertiesOperation(IResourceProvider provider, boolean isRecursive) {
        super(provider, isRecursive);
    }

    protected void doAdd(IResource current, final ISVNConnector proxy, final IProgressMonitor monitor) throws Exception {
        super.doAdd(current, proxy, monitor);
        if (!this.isRecursive) {
            this.processResource(current, proxy, monitor);
        } else {
            FileUtility.visitNodes(current, new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (monitor.isCanceled() || FileUtility.isNotSupervised(resource)) {
                        return false;
                    }
                    try {
                        AddToSVNWithPropertiesOperation.this.processResource(resource, proxy, monitor);
                    }
                    catch (SVNConnectorException cwe) {
                        AddToSVNWithPropertiesOperation.this.reportStatus(4, null, cwe);
                        return false;
                    }
                    return true;
                }
            }, 2);
        }
    }

    protected void processResource(IResource resource, ISVNConnector proxy, IProgressMonitor monitor) throws SVNConnectorException {
        String path = FileUtility.getWorkingCopyPath(resource);
        SVNProperty[] properties = CoreExtensionsManager.instance().getOptionProvider().getAutomaticProperties(resource.getName());
        int pCount = 0;
        while (pCount < properties.length) {
            proxy.setPropertyLocal(new String[]{path}, properties[pCount], SVNDepth.EMPTY, 0L, null, new SVNProgressMonitor(this, monitor, null));
            ++pCount;
        }
        if (resource.getType() == 1) {
            this.processFile(resource, proxy, monitor);
        }
    }

    protected void processFile(IResource resource, ISVNConnector proxy, IProgressMonitor monitor) throws SVNConnectorException {
        String path = FileUtility.getWorkingCopyPath(resource);
        int type = FileUtility.getMIMEType(resource);
        SVNProperty data = proxy.getProperty(new SVNEntryRevisionReference(path), "svn:mime-type", null, new SVNProgressMonitor(this, monitor, null));
        if (data == null) {
            if (type == 2) {
                proxy.setPropertyLocal(new String[]{path}, new SVNProperty("svn:mime-type", BINARY_FILE), SVNDepth.EMPTY, 0L, null, new SVNProgressMonitor(this, monitor, null));
            } else if (this.doMarkTextFiles && type == 1) {
                proxy.setPropertyLocal(new String[]{path}, new SVNProperty("svn:mime-type", TEXT_FILE), SVNDepth.EMPTY, 0L, null, new SVNProgressMonitor(this, monitor, null));
            }
        }
    }
}

