/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.utility;

import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;

public class AsynchronousActiveQueue {
    protected String name;
    protected LinkedList queue;
    protected IRecordHandler handler;
    protected boolean system;

    public AsynchronousActiveQueue(String queueName, IRecordHandler handler, boolean system) {
        this.name = queueName;
        this.queue = new LinkedList();
        this.handler = handler;
        this.system = system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(Object ... data) {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.add(data);
            if (this.queue.size() == 1) {
                ProgressMonitorUtility.doTaskScheduledDefault(new AbstractActionOperation(this.name, SVNMessages.class){

                    public ISchedulingRule getSchedulingRule() {
                        return null;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void runImpl(IProgressMonitor monitor) throws Exception {
                        while (true) {
                            Object[] record;
                            LinkedList linkedList = AsynchronousActiveQueue.this.queue;
                            synchronized (linkedList) {
                                if (monitor.isCanceled() || AsynchronousActiveQueue.this.queue.size() == 0) {
                                    AsynchronousActiveQueue.this.queue.clear();
                                    break;
                                }
                                record = (Object[])AsynchronousActiveQueue.this.queue.get(0);
                            }
                            AsynchronousActiveQueue.this.handler.process(monitor, this, record);
                            linkedList = AsynchronousActiveQueue.this.queue;
                            synchronized (linkedList) {
                                AsynchronousActiveQueue.this.queue.remove(0);
                                if (AsynchronousActiveQueue.this.queue.size() == 0) {
                                    break;
                                }
                            }
                        }
                    }
                }, this.system);
            }
        }
    }

    public static interface IRecordHandler {
        public void process(IProgressMonitor var1, IActionOperation var2, Object ... var3);
    }
}

