/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.graphic.figure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathFigure
extends Label {
    protected static final String PATH_SEPARATOR = "/";
    protected String parentPath;
    protected boolean isShowFullPath;
    protected String subStringText;
    protected int subStringTextIndex = -1;
    protected String[] multiLineSubstringText = new String[0];
    protected int verticalTextGap = 0;
    protected int figureWidth = -1;
    protected Color defaultColor = ColorConstants.black;
    protected Color reverseDefaultColor = ColorConstants.white;
    protected Color commonPathPartsColor = ColorConstants.gray;
    protected Color reverseCommonPathPartsColor = FigureUtilities.lighter((Color)this.commonPathPartsColor);
    protected Color differentPathPartsColor = ColorConstants.black;
    protected Color reverseDifferentPathPartsColor = ColorConstants.white;
    protected boolean isSelected;

    public PathFigure() {
        this.setLabelAlignment(1);
        this.setTextAlignment(8);
    }

    public void setShowFullPath(boolean isShowFullPath) {
        this.isShowFullPath = isShowFullPath;
        this.revalidate();
        this.repaint();
    }

    public void setPaths(String path, String parentPath) {
        this.parentPath = parentPath;
        this.setText(path);
    }

    public void setSelected(boolean isSelected) {
        if (this.isSelected == isSelected) {
            return;
        }
        this.isSelected = isSelected;
        this.repaint();
    }

    protected void paintFigure(Graphics graphics) {
        Rectangle bounds = this.getBounds();
        graphics.translate(bounds.x, bounds.y);
        Point textLocation = this.getTextLocation();
        if (this.isShowFullPath) {
            Color color = this.isSelected ? this.reverseDefaultColor : this.defaultColor;
            graphics.setForegroundColor(color);
            String[] lines = this.getMultiLineSubStringText();
            int i = 0;
            while (i < lines.length) {
                graphics.drawText(lines[i], textLocation);
                if (i != lines.length - 1) {
                    int offset = FigureUtilities.getStringExtents((String)lines[i], (Font)this.getFont()).height + this.verticalTextGap;
                    textLocation = new Point(textLocation.x, textLocation.y + offset);
                }
                ++i;
            }
        } else {
            Color diffColor;
            Color commonColor;
            if (this.isSelected) {
                commonColor = this.reverseCommonPathPartsColor;
                diffColor = this.reverseDifferentPathPartsColor;
            } else {
                commonColor = this.commonPathPartsColor;
                diffColor = this.differentPathPartsColor;
            }
            graphics.setForegroundColor(commonColor);
            String text = this.getSubStringText();
            if (this.subStringTextIndex != -1) {
                String firstPathPart = text.substring(0, this.subStringTextIndex);
                graphics.drawText(firstPathPart, textLocation);
                try {
                    graphics.setForegroundColor(diffColor);
                    int offset = FigureUtilities.getStringExtents((String)firstPathPart, (Font)this.getFont()).width;
                    textLocation = new Point(textLocation.x + offset, textLocation.y);
                    String secondPathPart = text.substring(this.subStringTextIndex);
                    graphics.drawText(secondPathPart, textLocation);
                }
                finally {
                    graphics.setForegroundColor(commonColor);
                }
            } else {
                graphics.drawText(text, textLocation);
            }
        }
        graphics.translate(-bounds.x, -bounds.y);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        int oldFigureWidth = this.figureWidth;
        if (this.figureWidth != wHint && wHint != -1) {
            this.figureWidth = wHint;
        }
        if (this.isShowFullPath) {
            if (this.prefSize == null || oldFigureWidth == -1 && this.figureWidth != -1) {
                String[] paths;
                this.prefSize = new Dimension(0, 0);
                String[] stringArray = paths = this.getMultiLineSubStringText(this.figureWidth);
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    String path = stringArray[n2];
                    Dimension lineSize = FigureUtilities.getStringExtents((String)path, (Font)this.getFont());
                    this.prefSize.width = Math.max(this.prefSize.width, lineSize.width);
                    this.prefSize.height += lineSize.height;
                    ++n2;
                }
                Insets insets = this.getInsets();
                this.prefSize.expand(insets.getWidth(), insets.getHeight());
                this.prefSize.height += this.verticalTextGap * (paths.length - 1);
                if (this.getLayoutManager() != null) {
                    this.prefSize.union(this.getLayoutManager().getPreferredSize((IFigure)this, wHint, hHint));
                }
            }
            if (wHint >= 0 && wHint < this.prefSize.width) {
                Dimension minSize = this.getMinimumSize(wHint, hHint);
                Dimension result = this.prefSize.getCopy();
                result.width = Math.min(result.width, wHint);
                result.width = Math.max(minSize.width, result.width);
                return result;
            }
            return this.prefSize;
        }
        return super.getPreferredSize(wHint, hHint);
    }

    protected String[] getMultiLineSubStringText() {
        return this.getMultiLineSubStringText(this.getSize().width);
    }

    protected String[] getMultiLineSubStringText(int width) {
        if (this.multiLineSubstringText.length > 0) {
            return this.multiLineSubstringText;
        }
        String[] pathParts = this.splitPath(this.getPath());
        ArrayList lines = new ArrayList();
        ArrayList<String> line = null;
        int i = 0;
        while (i < pathParts.length) {
            String linePath;
            if (line == null) {
                line = new ArrayList<String>();
                lines.add(line);
            }
            line.add(pathParts[i]);
            if (line.size() > 1 && this.isTruncate(linePath = this.createPath(line.toArray(new String[0])), width)) {
                line.remove(line.size() - 1);
                line = null;
                --i;
            }
            ++i;
        }
        this.multiLineSubstringText = new String[lines.size()];
        i = 0;
        while (i < lines.size()) {
            List lineList = (List)lines.get(i);
            this.multiLineSubstringText[i] = this.createPath(lineList.toArray(new String[0]));
            ++i;
        }
        return this.multiLineSubstringText;
    }

    public String getSubStringText() {
        if (this.subStringText != null) {
            return this.subStringText;
        }
        int deletedCount = 0;
        String[] strParts = this.splitPath(this.getPath());
        LinkedList<String> parts = new LinkedList<String>(Arrays.asList(strParts));
        if (this.getPreferredSize().width - this.getSize().width > 0) {
            if (parts.size() > 2) {
                String path;
                while (this.isTruncate(path = this.createPath(parts.toArray(new String[0])))) {
                    if (deletedCount == 0) {
                        parts.remove(1);
                        parts.add(1, this.getTruncationString());
                    } else {
                        parts.remove(2);
                    }
                    ++deletedCount;
                    if (parts.size() > 3) continue;
                }
            }
            this.subStringText = this.createPath(parts.toArray(new String[0]));
        } else {
            this.subStringText = this.getPath();
        }
        this.calculateNotEqualParts(deletedCount, parts);
        return this.subStringText;
    }

    protected void calculateNotEqualParts(int deletedCount, List<String> newPathParts) {
        if (this.parentPath != null) {
            String[] pathParts = this.splitPath(this.getPath());
            String[] parentParts = this.splitPath(this.parentPath);
            int notEqualSegment = -1;
            int i = 0;
            int n = Math.min(pathParts.length, parentParts.length);
            while (i < n) {
                String pathPart = pathParts[i];
                String parentPart = parentParts[i];
                if (!pathPart.equals(parentPart)) {
                    notEqualSegment = i;
                    break;
                }
                ++i;
            }
            if (notEqualSegment != -1) {
                int startSegment = deletedCount != 0 ? (notEqualSegment == 0 ? 0 : (notEqualSegment >= 1 && notEqualSegment <= deletedCount ? 1 : notEqualSegment - deletedCount + 1)) : notEqualSegment;
                String tmpPath = this.createPath(newPathParts.toArray(new String[0]), startSegment);
                this.subStringTextIndex = tmpPath.length();
            }
        } else {
            this.subStringTextIndex = 0;
        }
    }

    protected String createPath(String[] parts) {
        return this.createPath(parts, parts.length);
    }

    protected String createPath(String[] parts, int length) {
        StringBuilder tmp = new StringBuilder();
        int i = 0;
        while (i < length) {
            tmp.append(PATH_SEPARATOR).append(parts[i]);
            ++i;
        }
        return tmp.toString();
    }

    protected String[] splitPath(String path) {
        if (path.startsWith(PATH_SEPARATOR)) {
            path = path.substring(1);
        }
        return path.split(PATH_SEPARATOR);
    }

    protected String getPath() {
        return this.getText();
    }

    protected boolean isTruncate(String path) {
        return this.isTruncate(path, this.getSize().width);
    }

    protected boolean isTruncate(String path, int width) {
        int textWidth = FigureUtilities.getStringExtents((String)path, (Font)this.getFont()).width;
        return width < textWidth;
    }

    public void invalidate() {
        this.subStringText = null;
        this.subStringTextIndex = -1;
        this.multiLineSubstringText = new String[0];
        super.invalidate();
    }
}

