/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.wizard;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.svn.ui.verifier.AbstractVerificationKeyListener;
import org.eclipse.team.svn.ui.verifier.AbstractVerifier;
import org.eclipse.team.svn.ui.verifier.IValidationManager;

public abstract class AbstractVerifiedWizardPage
extends WizardPage
implements IValidationManager {
    private VerificationKeyListener changeListener = new VerificationKeyListener();

    public AbstractVerifiedWizardPage(String pageName) {
        super(pageName);
    }

    public AbstractVerifiedWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        this.setControl((Control)this.createControlImpl(parent));
        this.addListeners();
    }

    public boolean isFilledRight() {
        return this.changeListener.isFilledRight();
    }

    public void attachTo(Control cmp, AbstractVerifier verifier) {
        this.changeListener.attachTo(cmp, verifier);
    }

    public void addListeners() {
        this.changeListener.addListeners();
        this.validateContent();
        this.setMessage(this.getDescription(), 0);
    }

    public void detachFrom(Control cmp) {
        this.changeListener.detachFrom(cmp);
    }

    public void detachAll() {
        this.changeListener.detachAll();
    }

    public void validateContent() {
        this.changeListener.validateContent();
    }

    public boolean validateControl(Control cmp) {
        return this.changeListener.validateControl(cmp);
    }

    public void setPageComplete(boolean complete) {
        super.setPageComplete(complete && this.isFilledRight() && this.isPageCompleteImpl());
    }

    public boolean isPageComplete() {
        if (this.getContainer().getCurrentPage() == this) {
            return super.isPageComplete();
        }
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.getControl().setFocus();
        }
    }

    public void setMessage(String newMessage, int newType) {
        if (newType == 2) {
            this.setMessage("", 0);
            this.setErrorMessage(null);
            super.setMessage(newMessage, newType);
        } else if (newType == 3) {
            this.setMessage("", 0);
            this.setErrorMessage(newMessage);
        } else {
            this.setErrorMessage(null);
            super.setMessage(newMessage, newType);
        }
    }

    protected abstract Composite createControlImpl(Composite var1);

    protected boolean isPageCompleteImpl() {
        return true;
    }

    protected class VerificationKeyListener
    extends AbstractVerificationKeyListener {
        public void hasError(String errorReason) {
            AbstractVerifiedWizardPage.this.setMessage(errorReason, 3);
            this.handleButtons();
        }

        public void hasWarning(String warningReason) {
            AbstractVerifiedWizardPage.this.setMessage(warningReason, 2);
            this.handleButtons();
        }

        public void hasNoError() {
            AbstractVerifiedWizardPage.this.setMessage(AbstractVerifiedWizardPage.this.getDescription(), 0);
            this.handleButtons();
        }

        protected void handleButtons() {
            AbstractVerifiedWizardPage.this.setPageComplete(this.isFilledRight());
        }
    }
}

