/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.texo.annotations.annotationsmodel.ENamedElementAnnotation;
import org.eclipse.emf.texo.generator.Annotator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationManager {
    private List<ENamedElementAnnotation> initialAnnotations = new ArrayList<ENamedElementAnnotation>();
    private final Map<EModelElement, List<ENamedElementAnnotation>> modelAnnotations = new HashMap<EModelElement, List<ENamedElementAnnotation>>();
    private Map<EClass, Annotator<? extends ENamedElementAnnotation>> annotators = new HashMap<EClass, Annotator<? extends ENamedElementAnnotation>>();

    public ENamedElementAnnotation getAnnotation(ENamedElement annotatedModelElement, EClass annotationEClass) {
        if (this.modelAnnotations.containsKey(annotatedModelElement)) {
            List<ENamedElementAnnotation> annotationList = this.modelAnnotations.get(annotatedModelElement);
            for (ENamedElementAnnotation annotation : annotationList) {
                if (!annotationEClass.isSuperTypeOf(annotation.eClass())) continue;
                return annotation;
            }
        }
        ENamedElementAnnotation initialAnnotation = null;
        for (ENamedElementAnnotation annotation : this.initialAnnotations) {
            if (!annotationEClass.isSuperTypeOf(annotation.eClass())) continue;
            initialAnnotation = annotation;
            break;
        }
        ENamedElementAnnotation newElementAnnotation = (ENamedElementAnnotation)annotationEClass.getEPackage().getEFactoryInstance().create(annotationEClass);
        if (initialAnnotation != null) {
            for (EStructuralFeature eFeature : annotationEClass.getEAllStructuralFeatures()) {
                if (!initialAnnotation.eIsSet(eFeature)) continue;
                newElementAnnotation.eSet(eFeature, initialAnnotation.eGet(eFeature));
            }
        }
        newElementAnnotation.setENamedElement(annotatedModelElement);
        this.addAnnotation(newElementAnnotation);
        if (this.annotators.containsKey(annotationEClass)) {
            this.annotators.get(annotationEClass).setAnnotationFeatures((ENamedElementAnnotation)newElementAnnotation);
        }
        return newElementAnnotation;
    }

    public List<ENamedElementAnnotation> getAnnotations(ENamedElement namedElement) {
        List<ENamedElementAnnotation> annotations = this.modelAnnotations.get(namedElement);
        if (annotations == null) {
            return Collections.emptyList();
        }
        return annotations;
    }

    protected void addAnnotation(ENamedElementAnnotation annotation) {
        List<ENamedElementAnnotation> annotations = this.modelAnnotations.get(annotation.getENamedElement());
        if (annotations == null) {
            annotations = new ArrayList<ENamedElementAnnotation>();
            this.modelAnnotations.put((EModelElement)annotation.getENamedElement(), annotations);
        }
        annotations.add(annotation);
    }

    public void addAnnotator(Annotator<? extends ENamedElementAnnotation> annotator) {
        this.annotators.put(annotator.getAnnotationEClass(), annotator);
        annotator.setAnnotationManager(this);
    }

    public Annotator<ENamedElementAnnotation> getAnnotator(EClass annotationEClass) {
        return this.annotators.get(annotationEClass);
    }

    public Map<EModelElement, List<ENamedElementAnnotation>> getModelAnnotations() {
        return this.modelAnnotations;
    }

    public List<ENamedElementAnnotation> getInitialAnnotations() {
        return this.initialAnnotations;
    }

    public void setInitialAnnotations(List<ENamedElementAnnotation> initialAnnotations) {
        this.initialAnnotations = initialAnnotations;
    }
}

