/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.generator;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xpand2.output.FileHandle;
import org.eclipse.xpand2.output.VetoStrategy;

public class FileCleaner {
    private List<String> fileLocations = new ArrayList<String>();

    public VetoStrategy getNewOutputLocationTracker() {
        return new OutputLocationTracker();
    }

    public void addFileLocation(String fileLocation) {
        this.fileLocations.add(fileLocation);
    }

    public void clean() {
        try {
            ArrayList directoryDone = new ArrayList();
            for (String fileLocation : this.fileLocations) {
                File file = new File(fileLocation);
                File directory = file.getParentFile();
                if (directoryDone.contains(directory.getAbsolutePath())) continue;
                File[] fileArray = directory.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File childFile = fileArray[n2];
                    if (!childFile.isDirectory() && !this.fileLocations.contains(childFile.getAbsolutePath())) {
                        childFile.delete();
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private class OutputLocationTracker
    implements VetoStrategy {
        private OutputLocationTracker() {
        }

        public boolean hasVeto(FileHandle handle) {
            FileCleaner.this.addFileLocation(handle.getTargetFile().getAbsolutePath());
            return false;
        }
    }
}

