/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.ThisExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportReferenceCollector
extends ASTVisitor {
    private List<ImportDeclaration> existingImports = new ArrayList<ImportDeclaration>();
    private List<String> qualifiedTypes = new ArrayList<String>();
    private String packageName = null;

    public ImportReferenceCollector() {
        super(true);
    }

    public List<ImportDeclaration> getExistingImports() {
        return this.existingImports;
    }

    public List<String> getQualifiedTypes() {
        return this.qualifiedTypes;
    }

    public String getPackageName() {
        return this.packageName;
    }

    private void typeRefFound(Name node) {
        if (node == null) {
            return;
        }
        if (!node.getFullyQualifiedName().contains(".") && Character.isLowerCase(node.getFullyQualifiedName().toCharArray()[0])) {
            return;
        }
        this.qualifiedTypes.add(node.getFullyQualifiedName());
    }

    private void doVisitChildren(List<?> elements) {
        int nElements = elements.size();
        int i = 0;
        while (i < nElements) {
            ((ASTNode)elements.get(i)).accept((ASTVisitor)this);
            ++i;
        }
    }

    private void doVisitNode(ASTNode node) {
        if (node != null) {
            node.accept((ASTVisitor)this);
        }
    }

    public boolean visit(ArrayType node) {
        this.doVisitNode((ASTNode)node.getElementType());
        return false;
    }

    public boolean visit(SimpleName node) {
        this.typeRefFound((Name)node);
        return false;
    }

    public boolean visit(SimpleType node) {
        this.typeRefFound(node.getName());
        return false;
    }

    public boolean visit(QualifiedType node) {
        return true;
    }

    public boolean visit(QualifiedName node) {
        this.typeRefFound((Name)node);
        return false;
    }

    public boolean visit(ImportDeclaration node) {
        this.existingImports.add(node);
        return false;
    }

    public boolean visit(PackageDeclaration node) {
        this.packageName = node.getName().getFullyQualifiedName();
        if (node.getAST().apiLevel() >= 3) {
            this.doVisitNode((ASTNode)node.getJavadoc());
            this.doVisitChildren(node.annotations());
        }
        return false;
    }

    public boolean visit(ThisExpression node) {
        this.typeRefFound(node.getQualifier());
        return false;
    }

    private void evalQualifyingExpression(Expression expr, Name selector) {
        if (expr != null) {
            if (expr instanceof Name) {
                Name name = (Name)expr;
                this.typeRefFound(name);
            } else {
                expr.accept((ASTVisitor)this);
            }
        }
    }

    public boolean visit(ClassInstanceCreation node) {
        this.doVisitChildren(node.typeArguments());
        this.doVisitNode((ASTNode)node.getType());
        this.evalQualifyingExpression(node.getExpression(), null);
        if (node.getAnonymousClassDeclaration() != null) {
            node.getAnonymousClassDeclaration().accept((ASTVisitor)this);
        }
        this.doVisitChildren(node.arguments());
        return false;
    }

    public boolean visit(MethodInvocation node) {
        this.evalQualifyingExpression(node.getExpression(), (Name)node.getName());
        this.doVisitChildren(node.typeArguments());
        this.doVisitChildren(node.arguments());
        return false;
    }

    public boolean visit(SuperConstructorInvocation node) {
        this.evalQualifyingExpression(node.getExpression(), null);
        this.doVisitChildren(node.typeArguments());
        this.doVisitChildren(node.arguments());
        return false;
    }

    public boolean visit(FieldAccess node) {
        this.evalQualifyingExpression(node.getExpression(), (Name)node.getName());
        return false;
    }

    public boolean visit(MarkerAnnotation node) {
        this.typeRefFound(node.getTypeName());
        return false;
    }

    public boolean visit(NormalAnnotation node) {
        this.typeRefFound(node.getTypeName());
        this.doVisitChildren(node.values());
        return false;
    }

    public boolean visit(SingleMemberAnnotation node) {
        this.typeRefFound(node.getTypeName());
        this.doVisitNode((ASTNode)node.getValue());
        return false;
    }

    public boolean visit(MethodDeclaration node) {
        this.doVisitNode((ASTNode)node.getJavadoc());
        if (node.getAST().apiLevel() >= 3) {
            this.doVisitChildren(node.modifiers());
            this.doVisitChildren(node.typeParameters());
        }
        if (!node.isConstructor()) {
            this.doVisitNode((ASTNode)node.getReturnType2());
        }
        this.doVisitChildren(node.parameters());
        Iterator iter = node.thrownExceptions().iterator();
        while (iter.hasNext()) {
            this.typeRefFound((Name)iter.next());
        }
        this.doVisitNode((ASTNode)node.getBody());
        return false;
    }

    public boolean visit(TagElement node) {
        Object first;
        String tagName = node.getTagName();
        List list = node.fragments();
        int idx = 0;
        if (tagName != null && !list.isEmpty() && (first = list.get(0)) instanceof Name) {
            if ("@throws".equals(tagName) || "@exception".equals(tagName)) {
                this.typeRefFound((Name)first);
            } else if ("@see".equals(tagName) || "@link".equals(tagName) || "@linkplain".equals(tagName)) {
                Name name = (Name)first;
                this.typeRefFound(name);
            }
            ++idx;
        }
        int i = idx;
        while (i < list.size()) {
            this.doVisitNode((ASTNode)list.get(i));
            ++i;
        }
        return false;
    }

    public boolean visit(MemberRef node) {
        Name qualifier = node.getQualifier();
        if (qualifier != null) {
            this.typeRefFound(qualifier);
        }
        return false;
    }

    public boolean visit(MethodRef node) {
        List list;
        Name qualifier = node.getQualifier();
        if (qualifier != null) {
            this.typeRefFound(qualifier);
        }
        if ((list = node.parameters()) != null) {
            this.doVisitChildren(list);
        }
        return false;
    }
}

