/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.generator;

import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.xpand2.output.FileHandle;
import org.eclipse.xpand2.output.PostProcessor;

public abstract class MergingOutputHandler
implements PostProcessor {
    private String projectName;
    private ProgressMonitor monitor;

    public void afterClose(FileHandle impl) {
    }

    public void beforeWriteAndClose(FileHandle fileHandle) {
        String targetLocation = fileHandle.getTargetFile().getAbsolutePath();
        if (this.monitor != null) {
            this.monitor.subTask(targetLocation);
        }
        try {
            boolean doMerge = false;
            String[] stringArray = this.getSupportedExtensions();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                if (targetLocation.endsWith(extension)) {
                    doMerge = true;
                    break;
                }
                ++n2;
            }
            if (doMerge) {
                this.merge(fileHandle);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception while merging and saving source file " + targetLocation, e);
        }
    }

    protected abstract void merge(FileHandle var1);

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    protected String[] getSupportedExtensions() {
        return new String[0];
    }

    public ProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
    }
}

