/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.generator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.texo.annotations.annotationsmodel.ENamedElementAnnotation;
import org.eclipse.emf.texo.generator.AnnotationManager;
import org.eclipse.emf.texo.generator.Annotator;
import org.eclipse.emf.texo.generator.ModelAnnotator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelController {
    private List<EPackage> ePackages = new ArrayList<EPackage>();
    private List<ModelAnnotator> modelAnnotators = new ArrayList<ModelAnnotator>();
    private AnnotationManager annotationManager = new AnnotationManager();

    public void annotate() {
        for (ModelAnnotator modelAnnotator : this.modelAnnotators) {
            modelAnnotator.setEPackages(this.ePackages);
            modelAnnotator.setAnnotationManager(this.annotationManager);
            for (Annotator<? extends ENamedElementAnnotation> annotator : modelAnnotator.getAnnotators()) {
                this.annotationManager.addAnnotator(annotator);
            }
        }
        for (ModelAnnotator modelAnnotator : this.modelAnnotators) {
            modelAnnotator.annotate();
        }
        for (ModelAnnotator modelAnnotator : this.modelAnnotators) {
            modelAnnotator.postAnnotate();
        }
    }

    public List<EPackage> getEPackages() {
        return this.ePackages;
    }

    public void setEPackages(List<EPackage> ePackages) {
        this.ePackages = ePackages;
    }

    public boolean isAnnotated(ENamedElement eNamedElement, String nsPrefix) {
        return this.getAnnotation(eNamedElement, nsPrefix) != null;
    }

    public ENamedElementAnnotation getAnnotation(ENamedElement eNamedElement, String nsURI) {
        List<ENamedElementAnnotation> annotations = this.getAnnotationManager().getAnnotations(eNamedElement);
        for (ENamedElementAnnotation annotation : annotations) {
            if (annotation.getENamedElement() != eNamedElement || !annotation.eClass().getEPackage().getNsURI().equals(nsURI)) continue;
            return annotation;
        }
        return null;
    }

    public String getJavaAnnotations(ENamedElement eNamedElement, String identifier) {
        List<ENamedElementAnnotation> annotations = this.getAnnotationManager().getAnnotations(eNamedElement);
        StringBuilder sb = new StringBuilder();
        for (ENamedElementAnnotation annotation : annotations) {
            String javaAnnotation;
            if (annotation.getENamedElement() != eNamedElement || (javaAnnotation = annotation.getJavaAnnotation(identifier)) == null) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(javaAnnotation);
        }
        return sb.toString();
    }

    public void addModelAnnotator(ModelAnnotator modelAnnotator) {
        modelAnnotator.setAnnotationManager(this.getAnnotationManager());
        this.modelAnnotators.add(modelAnnotator);
    }

    public void setModelAnnotators(List<ModelAnnotator> modelAnnotators) {
        this.modelAnnotators = modelAnnotators;
    }

    public void setInitialAnnotations(List<ENamedElementAnnotation> initialAnnotations) {
        this.getAnnotationManager().setInitialAnnotations(initialAnnotations);
    }

    public AnnotationManager getAnnotationManager() {
        return this.annotationManager;
    }

    public void setAnnotationManager(AnnotationManager annotationManager) {
        this.annotationManager = annotationManager;
    }
}

