/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.generator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.mwe.core.WorkflowRunner;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.issues.IssuesImpl;
import org.eclipse.emf.mwe.core.issues.MWEDiagnostic;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitorAdapter;
import org.eclipse.emf.texo.generator.ArtifactGenerationException;
import org.eclipse.emf.texo.generator.ModelController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkFlowStarter {
    public static final String MODEL_CONTROLLER_CONTEXT_SLOT = "modelController";
    public static final String PARAMETER_SOURCE_FOLDER = "defaultSourceFolder";
    public static final String PARAMETER_PROJECT_NAME = "projectName";
    private IProgressMonitor monitor = new NullProgressMonitor();

    public void generateModelCode(String projectName, List<EPackage> ePackages, ModelController modelController, String defaultSourceFolder) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        HashMap<String, Object> slotContents = new HashMap<String, Object>();
        slotContents.put(MODEL_CONTROLLER_CONTEXT_SLOT, modelController);
        parameters.put(PARAMETER_SOURCE_FOLDER, defaultSourceFolder);
        if (this.isXtendHelios()) {
            this.runWorkFlow(projectName, "/org/eclipse/emf/texo/generator/generate_model_36.oaw", parameters, slotContents);
        } else {
            this.runWorkFlow(projectName, "/org/eclipse/emf/texo/generator/generate_model.oaw", parameters, slotContents);
        }
    }

    private boolean isXtendHelios() {
        try {
            this.getClass().getClassLoader().loadClass("org.eclipse.xtend.type.impl.java.JavaMetaModel");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void runWorkFlow(String projectName, String templatePath, Map<String, String> parameters, Map<String, Object> slotContents) {
        try {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            parameters.put(PARAMETER_PROJECT_NAME, projectName);
            project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            Issues issues = this.runWorkFlow(templatePath, parameters, slotContents);
            if (issues == null) {
                throw new IllegalStateException("Could not perform requested action for unknown reason.");
            }
            if (issues.getErrors().length > 0) {
                StringBuilder sb = new StringBuilder();
                MWEDiagnostic[] mWEDiagnosticArray = issues.getErrors();
                int n = mWEDiagnosticArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MWEDiagnostic mweDiagnostic = mWEDiagnosticArray[n2];
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(this.getDiagnosticMessages((Diagnostic)mweDiagnostic, ""));
                    ++n2;
                }
                throw new ArtifactGenerationException("Errors found during artifact generations\nThe following error(s) where encountered:\n" + sb.toString(), issues);
            }
            project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            throw new IllegalStateException(e);
        }
    }

    public Issues runWorkFlow(String workFlowFile, Map<String, String> parameters, Map<String, ?> slotContents) {
        WorkflowRunner wfr = new WorkflowRunner();
        ProgressMonitorAdapter progressMonitor = new ProgressMonitorAdapter(this.getMonitor());
        if (!wfr.prepare(workFlowFile, (ProgressMonitor)progressMonitor, parameters)) {
            return null;
        }
        IssuesImpl issues = new IssuesImpl();
        wfr.executeWorkflow(slotContents, (Issues)issues);
        return issues;
    }

    private String getDiagnosticMessages(Diagnostic diagnostic, String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(prefix) + " " + diagnostic.getSource() + ": " + diagnostic.getMessage());
        for (Diagnostic child : diagnostic.getChildren()) {
            sb.append("\n" + prefix + this.getDiagnosticMessages(child, String.valueOf(prefix) + ">"));
        }
        return sb.toString();
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }
}

