/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.datagenerator;

import java.util.List;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataGeneratorUtils {
    public static EEnum getEnumBaseDataTypeIfObject(EDataType eDataType) {
        if (eDataType instanceof EEnum) {
            return null;
        }
        ExtendedMetaData extendedMetaData = ExtendedMetaData.INSTANCE;
        EDataType baseDataType = eDataType;
        while (baseDataType != null) {
            if (baseDataType instanceof EEnum) {
                return (EEnum)baseDataType;
            }
            baseDataType = extendedMetaData.getBaseType(baseDataType);
        }
        return null;
    }

    public static Class<?> getInstanceClass(EDataType eDataType) {
        List memberTypes;
        Class clz = eDataType.getInstanceClass();
        if (clz != null && clz != Object.class) {
            return eDataType.getInstanceClass();
        }
        if (clz == Object.class && (memberTypes = ExtendedMetaData.INSTANCE.getMemberTypes(eDataType)) != null && memberTypes.size() > 0) {
            return DataGeneratorUtils.getInstanceClass((EDataType)memberTypes.get(0));
        }
        EDataType baseType = ExtendedMetaData.INSTANCE.getBaseType(eDataType);
        if (baseType != null) {
            return DataGeneratorUtils.getInstanceClass(baseType);
        }
        return String.class;
    }

    public static boolean isMixed(EStructuralFeature feature) {
        EAnnotation eAnnotation = feature.getEAnnotation("http:///org/eclipse/emf/ecore/util/ExtendedMetaData");
        if (eAnnotation == null) {
            return false;
        }
        String kind = (String)eAnnotation.getDetails().get((Object)"kind");
        String name = (String)eAnnotation.getDetails().get((Object)"name");
        return kind != null && kind.compareTo("elementWildcard") == 0 && name != null && name.compareTo(":mixed") == 0;
    }
}

