/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.datagenerator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.texo.datagenerator.DataGeneratorFactory;
import org.eclipse.emf.texo.datagenerator.DataGeneratorUtils;
import org.eclipse.emf.texo.datagenerator.EStructuralFeatureDataGenerator;

public class FeatureMapDataGenerator
extends EStructuralFeatureDataGenerator {
    private List<EStructuralFeatureDataGenerator> dataGenerators = new ArrayList<EStructuralFeatureDataGenerator>();
    private int currentIndex = 0;

    public void setEStructuralFeature(EStructuralFeature structuralFeature) {
        super.setEStructuralFeature(structuralFeature);
    }

    public void setFeatures(EClass eClass) {
        DataGeneratorFactory factory = this.getModelDataGenerator().getDataGeneratorFactory();
        boolean isMixed = DataGeneratorUtils.isMixed(this.getEStructuralFeature());
        for (EStructuralFeature eFeature : eClass.getEAllStructuralFeatures()) {
            if (!eFeature.isChangeable()) continue;
            if (isMixed && eFeature.isVolatile()) {
                this.dataGenerators.add(factory.createEStructuralFeatureDataGenerator(eClass, eFeature, this.getModelDataGenerator()));
                continue;
            }
            if (this.getEStructuralFeature() != ExtendedMetaData.INSTANCE.getGroup(eFeature)) continue;
            this.dataGenerators.add(factory.createEStructuralFeatureDataGenerator(eClass, eFeature, this.getModelDataGenerator()));
        }
        if (isMixed) {
            this.dataGenerators.add(factory.createEStructuralFeatureDataGenerator(eClass, (EStructuralFeature)XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_Text(), this.getModelDataGenerator()));
            this.dataGenerators.add(factory.createEStructuralFeatureDataGenerator(eClass, (EStructuralFeature)XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_CDATA(), this.getModelDataGenerator()));
            this.dataGenerators.add(factory.createEStructuralFeatureDataGenerator(eClass, (EStructuralFeature)XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_Comment(), this.getModelDataGenerator()));
        }
    }

    public void setData(EObject owner) {
        boolean maxDepthReached;
        if (owner.eIsSet(this.getEStructuralFeature())) {
            return;
        }
        if (!this.getEStructuralFeature().isRequired() && this.getModelDataGenerator().isConsiderOnlyMandatoryFeatures()) {
            return;
        }
        if (this.dataGenerators.isEmpty()) {
            return;
        }
        boolean bl = maxDepthReached = this.getModelDataGenerator().getMaxDepth() < this.computeDepth(owner);
        if (maxDepthReached) {
            return;
        }
        FeatureMap featureMap = (FeatureMap)owner.eGet(this.getEStructuralFeature());
        int i = 0;
        while (i < this.getModelDataGenerator().getCollectionSize()) {
            FeatureMap.Entry entry = (FeatureMap.Entry)this.createValue(owner);
            featureMap.add(entry.getEStructuralFeature(), entry.getValue());
            ++i;
        }
    }

    public Object createValue(EObject owner) {
        if (this.currentIndex >= this.dataGenerators.size()) {
            this.currentIndex = 0;
        }
        EStructuralFeatureDataGenerator dataGenerator = this.dataGenerators.get(this.currentIndex++);
        EStructuralFeature eFeature = dataGenerator.getEStructuralFeature();
        Object value = dataGenerator.createValue(owner);
        FeatureMap.Entry entry = FeatureMapUtil.createEntry((EStructuralFeature)eFeature, (Object)value);
        return entry;
    }

    private int computeDepth(EObject owner) {
        if (owner.eContainer() == null) {
            return 0;
        }
        return 1 + this.computeDepth(owner.eContainer());
    }
}

