/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.datagenerator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.texo.datagenerator.DataGeneratorFactory;
import org.eclipse.emf.texo.datagenerator.EClassDataGenerator;
import org.eclipse.emf.texo.datagenerator.EDataTypeDataGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelDataGenerator {
    private List<EObject> toSetData = new ArrayList<EObject>();
    private List<EObject> allEObjects = new ArrayList<EObject>();
    private List<EObject> rootObjects = new ArrayList<EObject>();
    private DataGeneratorFactory dataGeneratorFactory = new DataGeneratorFactory();
    private List<EClass> startEClasses = null;
    private List<EPackage> ePackages = null;
    private Map<EClass, EClassDataGenerator> eClassDataGenerators = new HashMap<EClass, EClassDataGenerator>();
    private Map<EDataType, EDataTypeDataGenerator> eDataTypeGenerators = new HashMap<EDataType, EDataTypeDataGenerator>();
    private int dataSize = 1;
    private int collectionSize = 5;
    private int maxObjects = 1000;
    private int maxObjectLimit = 10000;
    private int maxDepth = 3;
    private int maxBreadth = 3;
    private boolean preventDanglingObjects = true;
    private boolean considerOnlyMandatoryFeatures = false;

    public void generateTestData() {
        if (this.ePackages == null) {
            throw new IllegalStateException("The EPackages property must be set");
        }
        if (this.startEClasses == null) {
            throw new IllegalStateException("The StartEClasses property must be set");
        }
        for (EClass eClass : this.startEClasses) {
            EClassDataGenerator eClassDataGenerator = this.getEClassDataGenerator(eClass);
            int i = 0;
            while (i < this.dataSize) {
                this.rootObjects.add(eClassDataGenerator.createEObject());
                ++i;
            }
        }
        for (EObject eObject : this.rootObjects) {
            this.buildTree(eObject, 0);
        }
        int breadthSteps = 0;
        while (this.toSetData.size() > 0) {
            if (this.allEObjects.size() > this.getMaxObjectLimit()) {
                throw new IllegalStateException("The system generated more than the maximum allowed objects, exiting");
            }
            ArrayList<EObject> dataToProcess = new ArrayList<EObject>(this.toSetData);
            this.toSetData.clear();
            this.setConsiderOnlyMandatoryFeatures(this.isConsiderOnlyMandatoryFeatures() || ++breadthSteps > this.getMaxBreadth());
            for (EObject eObject : dataToProcess) {
                EClassDataGenerator eClassDataGenerator = this.getEClassDataGenerator(eObject.eClass());
                this.setConsiderOnlyMandatoryFeatures(this.isConsiderOnlyMandatoryFeatures() || this.allEObjects.size() > this.getMaxObjects());
                eClassDataGenerator.setData(eObject);
            }
        }
        if (this.preventDanglingObjects) {
            this.solveDanglingObjects();
        }
    }

    private void buildTree(EObject eObject, int depth) {
        if (eObject.eContainer() != null) {
            return;
        }
        ArrayList<EObject> children = new ArrayList<EObject>();
        for (EReference eReference : eObject.eClass().getEAllReferences()) {
            if (eReference.isVolatile() || !eReference.isChangeable() || !eReference.isContainment()) continue;
            EClassDataGenerator eClassDataGenerator = this.getEClassDataGenerator(eReference.getEReferenceType());
            if (eReference.isMany()) {
                int i = 0;
                while (i < this.getCollectionSize()) {
                    EObject child = eClassDataGenerator.getCreateEObject(eObject, eReference);
                    Collection values = (Collection)eObject.eGet((EStructuralFeature)eReference);
                    values.add(child);
                    children.add(child);
                    ++i;
                }
                continue;
            }
            EObject child = eClassDataGenerator.getCreateEObject(eObject, eReference);
            eObject.eSet((EStructuralFeature)eReference, (Object)child);
            children.add(child);
        }
        if (depth < this.getMaxDepth()) {
            for (EObject child : children) {
                this.buildTree(child, depth + 1);
            }
        }
    }

    private void solveDanglingObjects() {
        ArrayList<EObject> notContainedEObjects = new ArrayList<EObject>();
        for (EObject eObject : this.allEObjects) {
            if (eObject.eContainer() != null || this.rootObjects.contains(eObject)) continue;
            notContainedEObjects.add(eObject);
            break;
        }
        while (!notContainedEObjects.isEmpty()) {
            ArrayList<EObject> repairedEObjects = new ArrayList<EObject>();
            for (EObject container : this.allEObjects) {
                for (EReference eReference : container.eClass().getEAllReferences()) {
                    if (eReference.isVolatile() || !eReference.isChangeable() || !eReference.isContainment() || !eReference.isMany() && container.eGet((EStructuralFeature)eReference) != null) continue;
                    for (EObject notContained : notContainedEObjects) {
                        if (!eReference.getEReferenceType().isSuperTypeOf(notContained.eClass())) continue;
                        if (eReference.isMany()) {
                            Collection values = (Collection)container.eGet((EStructuralFeature)eReference);
                            values.add(notContained);
                        } else {
                            container.eSet((EStructuralFeature)eReference, (Object)notContained);
                        }
                        repairedEObjects.add(notContained);
                    }
                }
            }
            if (repairedEObjects.isEmpty()) break;
            notContainedEObjects.removeAll(repairedEObjects);
        }
    }

    public boolean isRootObject(EObject eObject) {
        return this.rootObjects.contains(eObject);
    }

    public List<EObject> getResult() {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject eObject : this.allEObjects) {
            if (eObject.eContainer() != null) continue;
            result.add(eObject);
        }
        return result;
    }

    protected void addToSetData(EObject eObject) {
        this.toSetData.add(eObject);
        this.allEObjects.add(eObject);
        if (this.toSetData.size() + this.getTotalObjectCount() > this.getMaxObjectLimit()) {
            throw new IllegalStateException("The system generated more (" + (this.toSetData.size() + this.getTotalObjectCount()) + ") than the maximum allowed objects (" + this.getMaxObjectLimit() + "), exiting");
        }
    }

    protected EClassDataGenerator getEClassDataGenerator(EClass eClass) {
        EClassDataGenerator eClassDataGenerator = this.eClassDataGenerators.get(eClass);
        if (eClassDataGenerator == null) {
            eClassDataGenerator = this.getDataGeneratorFactory().createEClassDataGenerator(eClass, this);
            this.eClassDataGenerators.put(eClass, eClassDataGenerator);
        }
        return eClassDataGenerator;
    }

    public EDataTypeDataGenerator getEDataTypeDataGenerator(EDataType eDataType, EAttribute eAttribute) {
        EDataTypeDataGenerator eDataTypeGenerator = this.eDataTypeGenerators.get(eDataType);
        if (eDataTypeGenerator == null) {
            eDataTypeGenerator = this.getDataGeneratorFactory().createEDataTypeDataGenerator(eDataType, this, eAttribute);
            this.eDataTypeGenerators.put(eDataType, eDataTypeGenerator);
        }
        return eDataTypeGenerator;
    }

    protected List<EClass> getAllConcreteEClasses(EClass eClass) {
        ArrayList<EClass> result = new ArrayList<EClass>();
        if (!eClass.isAbstract() && !eClass.isInterface()) {
            result.add(eClass);
        }
        for (EPackage ePackage : this.getEPackages()) {
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                EClass checkEClass;
                if (!(eClassifier instanceof EClass) || !(checkEClass = (EClass)eClassifier).getEAllSuperTypes().contains((Object)eClass) || checkEClass.isAbstract() || checkEClass.isInterface()) continue;
                result.add(checkEClass);
            }
        }
        return result;
    }

    public List<EClass> getAllSubEClasses(EClass eClass) {
        ArrayList<EClass> result = new ArrayList<EClass>();
        for (EPackage ePackage : this.getEPackages()) {
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                EClass checkEClass;
                if (!(eClassifier instanceof EClass) || !(checkEClass = (EClass)eClassifier).getESuperTypes().contains((Object)eClass)) continue;
                result.add(checkEClass);
            }
        }
        return result;
    }

    public int getCollectionSize() {
        return this.collectionSize;
    }

    public void setCollectionSize(int collectionSize) {
        this.collectionSize = collectionSize;
    }

    public DataGeneratorFactory getDataGeneratorFactory() {
        return this.dataGeneratorFactory;
    }

    public void setDataGeneratorFactory(DataGeneratorFactory dataGeneratorFactory) {
        this.dataGeneratorFactory = dataGeneratorFactory;
    }

    public List<EClass> getStartEClasses() {
        return this.startEClasses;
    }

    public void setStartEClasses(List<EClass> startEClasses) {
        this.startEClasses = startEClasses;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(int dataSize) {
        this.dataSize = dataSize;
    }

    public int getMaxObjects() {
        return this.maxObjects;
    }

    public void setMaxObjects(int maxObjects) {
        this.maxObjects = maxObjects;
        this.setMaxObjectLimit(2 * maxObjects);
    }

    public int getMaxObjectLimit() {
        return this.maxObjectLimit;
    }

    public void setMaxObjectLimit(int maxObjectLimit) {
        this.maxObjectLimit = maxObjectLimit;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public List<EPackage> getEPackages() {
        return this.ePackages;
    }

    public void setEPackages(List<EPackage> packages) {
        this.ePackages = packages;
    }

    public int getTotalObjectCount() {
        return this.allEObjects.size();
    }

    public boolean isPreventDanglingObjects() {
        return this.preventDanglingObjects;
    }

    public void setPreventDanglingObjects(boolean preventDanglingObjects) {
        this.preventDanglingObjects = preventDanglingObjects;
    }

    public boolean isConsiderOnlyMandatoryFeatures() {
        return this.considerOnlyMandatoryFeatures;
    }

    public void setConsiderOnlyMandatoryFeatures(boolean considerOnlyMandatoryFeatures) {
        this.considerOnlyMandatoryFeatures = considerOnlyMandatoryFeatures;
    }

    public int getMaxBreadth() {
        return this.maxBreadth;
    }

    public void setMaxBreadth(int maxBreadth) {
        this.maxBreadth = maxBreadth;
    }
}

