/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.modelgenerator.annotator;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.texo.generator.AnnotationManager;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EAttributeModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EClassModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EDataTypeModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EEnumModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.ENamedElementModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EPackageModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EReferenceModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EStructuralFeatureModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.ModelcodegeneratorPackage;
import org.eclipse.emf.texo.utils.Check;

public abstract class ModelENamedElementAnnotator {
    private AnnotationManager annotationManager;

    protected void annotate(ENamedElementModelGenAnnotation annotation) {
        Check.isTrue((boolean)this.getAnnotationEClass().isSuperTypeOf(annotation.eClass()), (String)("Invalid annotation eclass " + annotation + " for this annotator " + this));
        Check.isNotNull((Object)annotation.getENamedElement(), (String)"eNamedElement must be set");
        annotation.setDocumentation(EcoreUtil.getDocumentation((EModelElement)annotation.getENamedElement()));
        annotation.setName(this.getName(annotation.getENamedElement()));
    }

    public abstract EClass getAnnotationEClass();

    protected String getName(ENamedElement namedElement) {
        return namedElement.getName();
    }

    public AnnotationManager getAnnotationManager() {
        return this.annotationManager;
    }

    public void setAnnotationManager(AnnotationManager annotationManager) {
        this.annotationManager = annotationManager;
    }

    protected EPackageModelGenAnnotation getEPackageModelGenAnnotation(EPackage ePackage) {
        return (EPackageModelGenAnnotation)this.annotationManager.getAnnotation((ENamedElement)ePackage, ModelcodegeneratorPackage.eINSTANCE.getEPackageModelGenAnnotation());
    }

    protected EClassModelGenAnnotation getEClassModelGenAnnotation(EClass eClass) {
        return (EClassModelGenAnnotation)this.annotationManager.getAnnotation((ENamedElement)eClass, ModelcodegeneratorPackage.eINSTANCE.getEClassModelGenAnnotation());
    }

    protected EStructuralFeatureModelGenAnnotation getEStructuralFeatureModelGenAnnotation(EStructuralFeature eFeature) {
        if (eFeature instanceof EReference) {
            return this.getEReferenceModelGenAnnotation((EReference)eFeature);
        }
        return this.getEAttributeModelGenAnnotation((EAttribute)eFeature);
    }

    protected EReferenceModelGenAnnotation getEReferenceModelGenAnnotation(EReference eReference) {
        return (EReferenceModelGenAnnotation)this.annotationManager.getAnnotation((ENamedElement)eReference, ModelcodegeneratorPackage.eINSTANCE.getEReferenceModelGenAnnotation());
    }

    protected EAttributeModelGenAnnotation getEAttributeModelGenAnnotation(EAttribute eAttribute) {
        return (EAttributeModelGenAnnotation)this.annotationManager.getAnnotation((ENamedElement)eAttribute, ModelcodegeneratorPackage.eINSTANCE.getEAttributeModelGenAnnotation());
    }

    protected EDataTypeModelGenAnnotation getEDataTypeModelGenAnnotation(EDataType eDataType) {
        if (eDataType instanceof EEnum) {
            return this.getEEnumModelGenAnnotation((EEnum)eDataType);
        }
        return (EDataTypeModelGenAnnotation)this.annotationManager.getAnnotation((ENamedElement)eDataType, ModelcodegeneratorPackage.eINSTANCE.getEDataTypeModelGenAnnotation());
    }

    protected EEnumModelGenAnnotation getEEnumModelGenAnnotation(EEnum eEnum) {
        return (EEnumModelGenAnnotation)this.annotationManager.getAnnotation((ENamedElement)eEnum, ModelcodegeneratorPackage.eINSTANCE.getEEnumModelGenAnnotation());
    }
}

