/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.modelgenerator.annotator;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.texo.generator.Annotator;
import org.eclipse.emf.texo.modelgenerator.annotator.GenUtils;
import org.eclipse.emf.texo.modelgenerator.annotator.ModelENamedElementAnnotator;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EClassModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EClassifierModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EDataTypeModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EEnumModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.EPackageModelGenAnnotation;
import org.eclipse.emf.texo.modelgenerator.modelannotations.ModelcodegeneratorPackage;
import org.eclipse.emf.texo.utils.Check;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelEPackageAnnotator
extends ModelENamedElementAnnotator
implements Annotator<EPackageModelGenAnnotation> {
    @Override
    public EClass getAnnotationEClass() {
        return ModelcodegeneratorPackage.eINSTANCE.getEPackageModelGenAnnotation();
    }

    public void setAnnotationFeatures(EPackageModelGenAnnotation annotation) {
        String packagePath;
        super.annotate(annotation);
        Check.isNotNull((Object)annotation.getEPackage(), (String)"ePackage must be set");
        EPackage ePackage = annotation.getEPackage();
        if (annotation.getPackagePath() == null) {
            packagePath = GenUtils.createJavaPackagePath(ePackage.getNsURI());
            annotation.setPackagePath(packagePath);
        } else {
            packagePath = annotation.getPackagePath();
        }
        if (annotation.getQualifiedClassName() == null) {
            annotation.setQualifiedClassName(String.valueOf(packagePath) + "." + this.getSimpleClassName(ePackage) + annotation.getModelPackageClassNamePostFix());
        }
        if (annotation.getSimpleClassName() == null) {
            annotation.setSimpleClassName(String.valueOf(this.getSimpleClassName(ePackage)) + annotation.getModelPackageClassNamePostFix());
        }
        if (annotation.getSimpleModelFactoryClassName() == null) {
            annotation.setSimpleModelFactoryClassName(String.valueOf(this.getSimpleClassName(ePackage)) + annotation.getModelFactoryClassNamePostFix());
        }
        if (annotation.getEcoreFileName() == null) {
            annotation.setEcoreFileName(String.valueOf(ePackage.getName()) + ".ecore");
        }
        List<EPackageModelGenAnnotation> dependsOn = this.getDependsOn(ePackage);
        if (annotation.getDependsOn().isEmpty()) {
            annotation.getDependsOn().addAll(dependsOn);
        }
        if (annotation.getEcoreFileContent() == null) {
            annotation.setEcoreFileContent(this.getEcoreFileContent(ePackage, dependsOn));
        }
    }

    public void postAnnotating(EPackageModelGenAnnotation annotation) {
        EPackage ePackage = annotation.getEPackage();
        if (annotation.getEClassifierAnnotations().isEmpty()) {
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                EClassifierModelGenAnnotation eClassifierAnnotation;
                if (eClassifier instanceof EClass) {
                    eClassifierAnnotation = (EClassModelGenAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)eClassifier, ModelcodegeneratorPackage.eINSTANCE.getEClassModelGenAnnotation());
                    annotation.getEClassifierAnnotations().add((Object)eClassifierAnnotation);
                    continue;
                }
                if (eClassifier instanceof EEnum) {
                    eClassifierAnnotation = (EEnumModelGenAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)eClassifier, ModelcodegeneratorPackage.eINSTANCE.getEEnumModelGenAnnotation());
                    annotation.getEClassifierAnnotations().add((Object)eClassifierAnnotation);
                    continue;
                }
                if (eClassifier instanceof EDataType) {
                    eClassifierAnnotation = (EDataTypeModelGenAnnotation)this.getAnnotationManager().getAnnotation((ENamedElement)eClassifier, ModelcodegeneratorPackage.eINSTANCE.getEDataTypeModelGenAnnotation());
                    annotation.getEClassifierAnnotations().add((Object)eClassifierAnnotation);
                    continue;
                }
                throw new IllegalStateException("Not supported here " + eClassifier);
            }
        }
    }

    private String getSimpleClassName(EPackage ePackage) {
        return GenUtils.upCaseFirst(this.getName((ENamedElement)ePackage));
    }

    private List<EPackageModelGenAnnotation> getDependsOn(EPackage ePackage) {
        HashSet<EPackage> epacks = new HashSet<EPackage>();
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            EPackage refEPackage;
            if (!(eClassifier instanceof EClass)) continue;
            EClass eClass = (EClass)eClassifier;
            for (EClass superEClass : eClass.getESuperTypes()) {
                if (superEClass.getEPackage() == ePackage || epacks.contains(superEClass.getEPackage())) continue;
                Check.isNotNull((Object)superEClass.getEPackage(), (String)("The epackage of the eclass " + superEClass + " is not set, it is the superEClass of " + eClass + ". This indicates that the super EClass is " + "not loaded correctly, for example the file with " + "the EPackage can not be found"));
                epacks.add(superEClass.getEPackage());
            }
            for (EReference eref : eClass.getEAllReferences()) {
                refEPackage = eref.getEReferenceType().getEPackage();
                if (refEPackage == ePackage || epacks.contains(refEPackage)) continue;
                epacks.add(refEPackage);
            }
            for (EAttribute eattr : eClass.getEAllAttributes()) {
                refEPackage = eattr.getEType().getEPackage();
                if (refEPackage == ePackage || epacks.contains(refEPackage)) continue;
                epacks.add(refEPackage);
            }
        }
        ArrayList<EPackageModelGenAnnotation> dependsOn = new ArrayList<EPackageModelGenAnnotation>();
        for (EPackage depEPackage : epacks) {
            if (depEPackage == EcorePackage.eINSTANCE || depEPackage == XMLTypePackage.eINSTANCE) continue;
            dependsOn.add(this.getEPackageModelGenAnnotation(depEPackage));
        }
        return dependsOn;
    }

    /*
     * Unable to fully structure code
     */
    public String getEcoreFileContent(EPackage ePackage, List<EPackageModelGenAnnotation> dependsOn) {
        previousURI = new HashMap<Resource, URI>();
        try {
            dependsOnEcorePackage = false;
            dependsOnXMLTypePackage = false;
            for (EPackageModelGenAnnotation dependsOnAnnotation : dependsOn) {
                if (dependsOnAnnotation.getEPackage() == ePackage) continue;
                localEPackage = dependsOnAnnotation.getEPackage();
                dependsOnEcorePackage |= localEPackage == EcorePackage.eINSTANCE;
                dependsOnXMLTypePackage |= localEPackage == XMLTypePackage.eINSTANCE;
                res = this.setEPackageResource(localEPackage);
                previousURI.put(res, res.getURI());
                res.setURI(URI.createURI((String)localEPackage.getNsURI()));
            }
            if (!dependsOnEcorePackage) {
                res = this.setEPackageResource((EPackage)EcorePackage.eINSTANCE);
                previousURI.put(res, res.getURI());
            }
            if (!dependsOnXMLTypePackage) {
                res = this.setEPackageResource((EPackage)XMLTypePackage.eINSTANCE);
                previousURI.put(res, res.getURI());
            }
            ecoreResourceFactory = new EcoreResourceFactoryImpl();
            outputRes = (XMIResource)ecoreResourceFactory.createResource(URI.createURI((String)""));
            outputRes.getContents().add((Object)ePackage);
            sw = new StringWriter();
            outputRes.save((Writer)sw, Collections.EMPTY_MAP);
            var11_11 = sw.toString();
            return var11_11;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            ** for (res : previousURI.keySet())
        }
lbl-1000:
        // 1 sources

        {
            res.setURI((URI)previousURI.get(res));
            continue;
        }
lbl37:
        // 1 sources

        throw var10_16;
    }

    private Resource setEPackageResource(EPackage ePackage) {
        Resource res = ePackage.eResource();
        if (res == null) {
            res = new XMIResourceImpl();
            res.getContents().add((Object)ePackage);
        }
        res.setURI(URI.createURI((String)ePackage.getNsURI()));
        return res;
    }

    @Override
    public String getName(ENamedElement namedElement) {
        String name = super.getName(namedElement);
        if (name.indexOf(".") != -1) {
            return name.substring(1 + name.lastIndexOf("."));
        }
        return name;
    }
}

