/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.eclipse.popup.actions;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.texo.eclipse.Messages;
import org.eclipse.emf.texo.eclipse.ProjectPropertyUtil;
import org.eclipse.emf.texo.eclipse.TexoEclipsePlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class AddRemoveNatureAction
implements IObjectActionDelegate {
    private Shell shell;
    private IProject project;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object element;
        this.project = selection == null ? null : ((element = ((IStructuredSelection)selection).getFirstElement()) == null ? null : ProjectPropertyUtil.getProject(element));
        action.setEnabled(this.project != null && this.project.isOpen());
    }

    public void run(IAction action) {
        if (this.project == null || !this.project.isOpen()) {
            return;
        }
        try {
            String key;
            IProjectDescription description = this.project.getDescription();
            ArrayList<String> natureIds = new ArrayList<String>();
            natureIds.addAll(Arrays.asList(description.getNatureIds()));
            if (natureIds.contains("org.eclipse.emf.texo.eclipse.nature")) {
                natureIds.remove("org.eclipse.emf.texo.eclipse.nature");
                key = "removedNature";
            } else {
                natureIds.add("org.eclipse.emf.texo.eclipse.nature");
                key = "addedNature";
            }
            description.setNatureIds(natureIds.toArray(new String[natureIds.size()]));
            this.project.setDescription(description, null);
            String title = Messages.getString(String.valueOf(key) + ".title");
            String message = Messages.formatMessage(String.valueOf(key) + ".message", this.project.getName());
            MessageDialog.openInformation((Shell)this.shell, (String)title, (String)message);
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)this.shell, (String)Messages.getString("error"), (String)Messages.getString("addRemoveNatureError.message"));
            TexoEclipsePlugin.getInstance().logException("Error adding/removing Elver UI project nature.", e);
        }
    }

    public void dispose() {
    }
}

