/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.texo.model.DynamicModelObject;
import org.eclipse.emf.texo.model.ModelFeatureMapEntry;
import org.eclipse.emf.texo.model.ModelObject;
import org.eclipse.emf.texo.model.ModelPackage;
import org.eclipse.emf.texo.model.ModelResolver;
import org.eclipse.emf.texo.utils.Check;
import org.eclipse.emf.texo.utils.ModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFModelConverter {
    private Map<EObject, Object> objectMapping = new HashMap<EObject, Object>();
    private List<EObject> toConvert = new ArrayList<EObject>();

    public List<Object> convert(List<EObject> eObjects) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (EObject eObject : eObjects) {
            result.add(this.createTarget(eObject));
        }
        while (!this.toConvert.isEmpty()) {
            ArrayList<EObject> beingConverted = new ArrayList<EObject>(this.toConvert);
            this.toConvert.clear();
            for (EObject eObject : beingConverted) {
                this.convertContent(eObject);
            }
        }
        return result;
    }

    protected Object createTarget(EObject eObject) {
        Object target = this.objectMapping.get(eObject);
        if (target != null) {
            return target;
        }
        target = this.createModelManagedObject(eObject);
        this.objectMapping.put(eObject, target);
        this.toConvert.add(eObject);
        return target;
    }

    protected void convertContent(EObject eObject) {
        Object target = this.objectMapping.get(eObject);
        ModelObject modelObject = ModelResolver.getInstance().getModelObject(target);
        for (EStructuralFeature eStructuralFeature : modelObject.eClass().getEAllStructuralFeatures()) {
            EReference eReference;
            EAttribute eAttribute;
            if (!eStructuralFeature.isChangeable() || eStructuralFeature.isVolatile()) continue;
            if (FeatureMapUtil.isFeatureMap((EStructuralFeature)eStructuralFeature)) {
                this.convertFeatureMap(eObject, modelObject, eStructuralFeature);
                continue;
            }
            if (eStructuralFeature.isMany()) {
                if (eStructuralFeature instanceof EAttribute) {
                    eAttribute = (EAttribute)eStructuralFeature;
                    this.convertManyEAttribute(eObject, modelObject, eAttribute);
                    continue;
                }
                eReference = (EReference)eStructuralFeature;
                if (eReference.isContainer()) continue;
                this.convertManyEReference(eObject, modelObject, eReference);
                continue;
            }
            if (eStructuralFeature instanceof EAttribute) {
                eAttribute = (EAttribute)eStructuralFeature;
                this.convertSingleEAttribute(eObject, modelObject, eAttribute);
                continue;
            }
            eReference = (EReference)eStructuralFeature;
            if (eReference.isContainer()) continue;
            this.convertSingleEReference(eObject, modelObject, eReference);
        }
    }

    protected Object createModelManagedObject(EObject eObject) {
        if (eObject.eClass() == EcorePackage.eINSTANCE.getEObject()) {
            DynamicModelObject modelObject = new DynamicModelObject();
            modelObject.setEClass(eObject.eClass());
            return modelObject;
        }
        ModelPackage modelPackage = ModelResolver.getInstance().getModelPackage(eObject.eClass().getEPackage().getNsURI());
        return modelPackage.getModelFactory().create(eObject.eClass());
    }

    protected void convertSingleEReference(EObject eObject, ModelObject<?> modelObject, EReference eReference) {
        EObject value = (EObject)eObject.eGet((EStructuralFeature)eReference);
        if (value == null) {
            modelObject.eSet((EStructuralFeature)eReference, null);
        } else {
            modelObject.eSet((EStructuralFeature)eReference, this.createTarget(value));
        }
    }

    protected void convertManyEReference(EObject eObject, ModelObject<?> modelObject, EReference eReference) {
        Collection eValues = (Collection)eObject.eGet((EStructuralFeature)eReference);
        if (ModelUtils.isEMap((EStructuralFeature)eReference)) {
            Map mValues = (Map)modelObject.eGet((EStructuralFeature)eReference);
            for (Object eValue : eValues) {
                Map.Entry entry = (Map.Entry)eValue;
                Object key = entry.getKey() instanceof EObject ? this.createTarget((EObject)entry.getKey()) : entry.getKey();
                Object value = entry.getValue() instanceof EObject ? this.createTarget((EObject)entry.getValue()) : entry.getValue();
                mValues.put(key, value);
            }
        } else {
            Collection mValues = (Collection)modelObject.eGet((EStructuralFeature)eReference);
            for (EObject eValue : eValues) {
                mValues.add(this.createTarget(eValue));
            }
        }
    }

    protected void convertSingleEAttribute(EObject eObject, ModelObject<?> modelObject, EAttribute eAttribute) {
        if (!eObject.eIsSet((EStructuralFeature)eAttribute)) {
            return;
        }
        Object eValue = eObject.eGet((EStructuralFeature)eAttribute);
        modelObject.eSet((EStructuralFeature)eAttribute, this.convertEAttributeValue(eValue, eAttribute.getEAttributeType()));
    }

    protected void convertFeatureMap(EObject eObject, ModelObject<?> modelObject, EStructuralFeature eFeature) {
        Collection eValues = (Collection)eObject.eGet(eFeature);
        Collection values = (Collection)modelObject.eGet(eFeature);
        for (Object eValue : eValues) {
            FeatureMap.Entry eEntry = (FeatureMap.Entry)eValue;
            Object featureMapEntry = ModelResolver.getInstance().createFeatureMapEntry(eFeature);
            ModelFeatureMapEntry mEntry = ModelResolver.getInstance().getModelFeatureMapEntry(eFeature, featureMapEntry);
            mEntry.setEStructuralFeature(eEntry.getEStructuralFeature());
            Object convertedValue = mEntry.getEStructuralFeature() instanceof EAttribute ? this.convertEAttributeValue(eEntry.getValue(), ((EAttribute)eEntry.getEStructuralFeature()).getEAttributeType()) : this.createTarget((EObject)eEntry.getValue());
            mEntry.setValue(convertedValue);
            values.add(featureMapEntry);
        }
    }

    protected void convertManyEAttribute(EObject eObject, ModelObject<?> modelObject, EAttribute eAttribute) {
        Collection eValues = (Collection)eObject.eGet((EStructuralFeature)eAttribute);
        EDataType eDataType = eAttribute.getEAttributeType();
        Collection values = (Collection)modelObject.eGet((EStructuralFeature)eAttribute);
        for (Object eValue : eValues) {
            values.add(this.convertEAttributeValue(eValue, eDataType));
        }
    }

    protected Object convertEAttributeValue(Object value, EDataType eDataType) {
        if (value instanceof EEnumLiteral) {
            EDataType enumDataType = this.getDataTypeOrBaseType(eDataType);
            Check.isInstanceOf((Object)enumDataType, EEnum.class);
            EEnumLiteral eeNumLiteral = (EEnumLiteral)value;
            ModelPackage modelPackage = ModelResolver.getInstance().getModelPackage(enumDataType.getEPackage().getNsURI());
            Class enumClass = modelPackage.getEClassifierClass((EClassifier)enumDataType);
            return Enum.valueOf(enumClass, eeNumLiteral.getName().toUpperCase());
        }
        if (value instanceof XMLGregorianCalendar) {
            XMLGregorianCalendar xmlCalendar = (XMLGregorianCalendar)value;
            Date date = xmlCalendar.toGregorianCalendar().getTime();
            return date;
        }
        return value;
    }

    private EDataType getDataTypeOrBaseType(EDataType eDataType) {
        EEnum baseType = ModelUtils.getEnumBaseDataTypeIfObject((EDataType)eDataType);
        if (baseType != null) {
            return baseType;
        }
        return eDataType;
    }
}

