/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.xml;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.ecore.xml.type.internal.XMLCalendar;
import org.eclipse.emf.texo.model.ModelFeatureMapEntry;
import org.eclipse.emf.texo.model.ModelObject;
import org.eclipse.emf.texo.model.ModelResolver;
import org.eclipse.emf.texo.utils.Check;
import org.eclipse.emf.texo.utils.ModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelEMFConverter {
    private Map<Object, InternalEObject> objectMapping = new HashMap<Object, InternalEObject>();
    private List<Object> toConvert = new ArrayList<Object>();

    public List<EObject> convert(List<Object> objects) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        Check.isNotNullArgument(objects, (String)"objects");
        for (Object object : objects) {
            result.add(this.createTarget(object));
        }
        while (!this.toConvert.isEmpty()) {
            ArrayList<Object> beingConverted = new ArrayList<Object>(this.toConvert);
            this.toConvert.clear();
            for (Object object : beingConverted) {
                this.convertContent(object);
            }
        }
        return result;
    }

    protected EObject createTarget(Object target) {
        InternalEObject eObject = this.objectMapping.get(target);
        if (eObject != null) {
            return eObject;
        }
        ModelObject modelObject = ModelResolver.getInstance().getModelObject(target);
        EClass eClass = modelObject.eClass();
        eObject = (InternalEObject)EcoreUtil.create((EClass)eClass);
        this.objectMapping.put(target, eObject);
        this.toConvert.add(target);
        return eObject;
    }

    protected void convertContent(Object target) {
        InternalEObject eObject = this.objectMapping.get(target);
        ModelObject modelObject = ModelResolver.getInstance().getModelObject(target);
        String proxyId = this.getProxyId(modelObject);
        if (proxyId != null) {
            eObject.eSetProxyURI(URI.createURI((String)proxyId));
            return;
        }
        for (EStructuralFeature eStructuralFeature : eObject.eClass().getEAllStructuralFeatures()) {
            EReference eReference;
            EAttribute eAttribute;
            if (!eStructuralFeature.isChangeable() || eStructuralFeature.isVolatile()) continue;
            if (FeatureMapUtil.isFeatureMap((EStructuralFeature)eStructuralFeature)) {
                this.convertFeatureMap(modelObject, (EObject)eObject, eStructuralFeature);
                continue;
            }
            if (eStructuralFeature.isMany()) {
                if (eStructuralFeature instanceof EAttribute) {
                    eAttribute = (EAttribute)eStructuralFeature;
                    this.convertManyEAttribute(modelObject, (EObject)eObject, eAttribute);
                    continue;
                }
                eReference = (EReference)eStructuralFeature;
                this.convertManyEReference(modelObject, (EObject)eObject, eReference);
                continue;
            }
            if (eStructuralFeature instanceof EAttribute) {
                eAttribute = (EAttribute)eStructuralFeature;
                this.convertSingleEAttribute(modelObject, (EObject)eObject, eAttribute);
                continue;
            }
            eReference = (EReference)eStructuralFeature;
            this.convertSingleEReference(modelObject, (EObject)eObject, eReference);
        }
    }

    protected String getProxyId(Object modelObject) {
        return null;
    }

    protected void convertFeatureMap(ModelObject<?> modelObject, EObject eObject, EStructuralFeature eFeature) {
        Collection mValues = (Collection)modelObject.eGet(eFeature);
        Collection values = (Collection)eObject.eGet(eFeature);
        for (Object mValue : mValues) {
            ModelFeatureMapEntry mEntry = ModelResolver.getInstance().getModelFeatureMapEntry(eFeature, mValue);
            EStructuralFeature entryFeature = mEntry.getEStructuralFeature();
            Object entryValue = mEntry.getValue();
            Object convertedValue = entryFeature instanceof EAttribute ? this.convertEAttributeValue(entryValue, ((EAttribute)entryFeature).getEAttributeType()) : this.createTarget(entryValue);
            FeatureMap.Entry eEntry = FeatureMapUtil.createEntry((EStructuralFeature)entryFeature, (Object)convertedValue);
            values.add(eEntry);
        }
    }

    protected void convertSingleEReference(ModelObject<?> modelObject, EObject eObject, EReference eReference) {
        Object value;
        if (eReference.isContainer()) {
            return;
        }
        if (eReference.getEOpposite() != null) {
            if (eObject.eIsSet((EStructuralFeature)eReference)) {
                return;
            }
            if (eReference.getEOpposite().isMany()) {
                return;
            }
        }
        if ((value = modelObject.eGet((EStructuralFeature)eReference)) == null) {
            eObject.eSet((EStructuralFeature)eReference, null);
        } else {
            InternalEObject eValue = (InternalEObject)this.createTarget(value);
            if (eObject.eGet((EStructuralFeature)eReference) == null) {
                eObject.eSet((EStructuralFeature)eReference, (Object)eValue);
            }
        }
    }

    protected void convertManyEReference(ModelObject<?> modelObject, EObject eObject, EReference eReference) {
        if (eReference.isContainer()) {
            return;
        }
        Object manyValue = modelObject.eGet((EStructuralFeature)eReference);
        if (Map.class.isAssignableFrom(manyValue.getClass())) {
            Check.isTrue((boolean)ModelUtils.isEMap((EStructuralFeature)eReference), (String)("Expected emap EReference, but this is not the case for EReference " + eReference));
            Collection eValues = (Collection)eObject.eGet((EStructuralFeature)eReference);
            Map map = (Map)manyValue;
            for (Object key : map.keySet()) {
                Object value = map.get(key);
                EObject mapEntryEObject = EcoreUtil.create((EClass)eReference.getEReferenceType());
                EStructuralFeature valueFeature = mapEntryEObject.eClass().getEStructuralFeature("value");
                EStructuralFeature keyFeature = mapEntryEObject.eClass().getEStructuralFeature("key");
                if (valueFeature instanceof EReference) {
                    mapEntryEObject.eSet(valueFeature, (Object)this.createTarget(value));
                } else {
                    mapEntryEObject.eSet(valueFeature, value);
                }
                if (keyFeature instanceof EReference) {
                    mapEntryEObject.eSet(keyFeature, (Object)this.createTarget(key));
                } else {
                    mapEntryEObject.eSet(keyFeature, key);
                }
                eValues.add(mapEntryEObject);
            }
        } else {
            Collection values = (Collection)manyValue;
            Collection eValues = (Collection)eObject.eGet((EStructuralFeature)eReference);
            for (Object value : values) {
                InternalEObject eValue = (InternalEObject)this.createTarget(value);
                if (eValues.contains(eValue)) continue;
                eValues.add(eValue);
            }
        }
    }

    protected void convertSingleEAttribute(ModelObject<?> modelObject, EObject eObject, EAttribute eAttribute) {
        Object value = modelObject.eGet((EStructuralFeature)eAttribute);
        ((InternalEObject)eObject).eSet((EStructuralFeature)eAttribute, this.convertEAttributeValue(value, eAttribute.getEAttributeType()));
    }

    protected void convertManyEAttribute(ModelObject<?> modelObject, EObject eObject, EAttribute eAttribute) {
        Collection values = (Collection)modelObject.eGet((EStructuralFeature)eAttribute);
        EDataType eDataType = eAttribute.getEAttributeType();
        List eValues = (List)eObject.eGet((EStructuralFeature)eAttribute);
        for (Object value : values) {
            eValues.add(this.convertEAttributeValue(value, eDataType));
        }
    }

    protected Object convertEAttributeValue(Object value, EDataType eDataType) {
        Date date;
        if (value instanceof Enum) {
            EDataType enumDataType = this.getDataTypeOrBaseType(eDataType);
            Check.isInstanceOf((Object)enumDataType, EEnum.class);
            EEnum eeNum = (EEnum)enumDataType;
            for (EEnumLiteral enumLiteral : eeNum.getELiterals()) {
                if (!enumLiteral.getName().toUpperCase().equals(((Enum)value).name())) continue;
                return enumLiteral;
            }
        }
        if (value instanceof Date && eDataType == XMLTypePackage.eINSTANCE.getDate()) {
            date = (Date)value;
            XMLCalendar xmlCalendar = new XMLCalendar(date, 2);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            xmlCalendar.clear();
            xmlCalendar.setYear(calendar.get(1));
            xmlCalendar.setMonth(1 + calendar.get(2));
            xmlCalendar.setDay(calendar.get(5));
            xmlCalendar.setTimezone(calendar.get(15) / 60000);
            return xmlCalendar;
        }
        if (value instanceof Date && eDataType == XMLTypePackage.eINSTANCE.getDateTime()) {
            date = (Date)value;
            return new XMLCalendar(date, 0);
        }
        return value;
    }

    private EDataType getDataTypeOrBaseType(EDataType eDataType) {
        EEnum baseType = ModelUtils.getEnumBaseDataTypeIfObject((EDataType)eDataType);
        if (baseType != null) {
            return baseType;
        }
        return eDataType;
    }
}

