/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.xml;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.texo.model.ModelPackage;
import org.eclipse.emf.texo.model.ModelResolver;
import org.eclipse.emf.texo.xml.DelegatingEFactory;

public class ModelXMLHelperImpl
extends XMLHelperImpl {
    private Map<String, DelegatingEFactory> eFactories = new HashMap<String, DelegatingEFactory>();

    public ModelXMLHelperImpl(XMLResource resource) {
        super(resource);
    }

    public String convertToString(EFactory factory, EDataType dataType, Object value) {
        ModelPackage modelPackage = this.getModelPackage(dataType);
        if (modelPackage != null) {
            return super.convertToString(this.getEFactory(modelPackage), dataType, value);
        }
        return super.convertToString(factory, dataType, value);
    }

    protected Object createFromString(EFactory eFactory, EDataType eDataType, String value) {
        boolean isString;
        if (eDataType instanceof EEnum) {
            EEnum eeNum = (EEnum)eDataType;
            EEnumLiteral eeNumLiteral = eeNum.getEEnumLiteralByLiteral(value);
            if (eeNumLiteral == null) {
                eeNumLiteral = eeNum.getEEnumLiteral(value);
            }
            if (eeNumLiteral == null) {
                throw new IllegalArgumentException("The value '" + value + "' is not a valid enumerator of '" + eDataType.getName() + "'");
            }
            return eeNumLiteral;
        }
        ModelPackage modelPackage = this.getModelPackage(eDataType);
        if (modelPackage != null) {
            return super.createFromString(this.getEFactory(modelPackage), eDataType, value);
        }
        boolean bl = isString = eDataType == XMLTypePackage.eINSTANCE.getString() || eDataType == XMLTypePackage.eINSTANCE.getNormalizedString();
        if (value != null && value.length() == 0 && !isString) {
            return null;
        }
        return super.createFromString(eFactory, eDataType, value);
    }

    private ModelPackage getModelPackage(EDataType eDataType) {
        return ModelResolver.getInstance().getModelPackage(eDataType.getEPackage().getNsURI());
    }

    private EFactory getEFactory(ModelPackage modelPackage) {
        if (!this.eFactories.containsKey(modelPackage.getNsURI())) {
            DelegatingEFactory delegatingEFactory = new DelegatingEFactory();
            delegatingEFactory.setModelFactory(modelPackage.getModelFactory());
            delegatingEFactory.setDelegate(modelPackage.getEPackage().getEFactoryInstance());
            this.eFactories.put(modelPackage.getNsURI(), delegatingEFactory);
            return delegatingEFactory;
        }
        return this.eFactories.get(modelPackage.getNsURI());
    }
}

