/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.xml;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.texo.xml.EMFModelConverter;
import org.eclipse.emf.texo.xml.ModelXMIResourceImpl;
import org.eclipse.emf.texo.xml.ModelXMLResourceImpl;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelXMLLoader {
    private Reader reader;
    private XMLResource xmlResource;
    private Map<String, Object> options = new HashMap<String, Object>();
    private List<Object> modelObjects;
    private EMFModelConverter emfModelConverter = new EMFModelConverter();
    private boolean loadAsXMI = false;

    public List<Object> read() {
        try {
            XMLResource localXMLResource = this.getXmlResource();
            this.setDefaultOptions("ENCODING", "UTF-8");
            this.setDefaultOptions("EXTENDED_META_DATA", true);
            this.setDefaultOptions("SUPPRESS_DOCUMENT_ROOT", true);
            this.setDefaultOptions("SCHEMA_LOCATION", true);
            this.setDefaultOptions("USE_ENCODED_ATTRIBUTE_STYLE", true);
            this.setDefaultOptions("USE_LEXICAL_HANDLER", true);
            localXMLResource.load(new InputSource(this.getReader()), this.options);
            return this.getEmfModelConverter().convert((List<EObject>)localXMLResource.getContents());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void setDefaultOptions(String option, Object value) {
        if (this.options.get(option) != null) {
            return;
        }
        this.options.put(option, value);
    }

    public XMLResource getXmlResource() {
        if (this.xmlResource == null) {
            this.xmlResource = this.loadAsXMI ? new ModelXMIResourceImpl() : new ModelXMLResourceImpl();
        }
        return this.xmlResource;
    }

    public void setXmlResource(XMLResource xmlResource) {
        this.xmlResource = xmlResource;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public List<Object> getModelObjects() {
        return this.modelObjects;
    }

    public void setModelObjects(List<Object> modelObjects) {
        this.modelObjects = modelObjects;
    }

    public Reader getReader() {
        return this.reader;
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public EMFModelConverter getEmfModelConverter() {
        return this.emfModelConverter;
    }

    public void setEmfModelConverter(EMFModelConverter emfModelConverter) {
        this.emfModelConverter = emfModelConverter;
    }

    public boolean isLoadAsXMI() {
        return this.loadAsXMI;
    }

    public void setLoadAsXMI(boolean loadAsXMI) {
        this.loadAsXMI = loadAsXMI;
    }
}

