/**
 * <copyright>
 *
 * Copyright (c) 2009, 2010 Springsite BV (The Netherlands) and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Martin Taal - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: ArtifactGenerator.java,v 1.13 2010/03/08 09:50:10 mtaal Exp $
 */
package org.eclipse.emf.texo.generator;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.xpand2.Generator;
import org.eclipse.xpand2.output.Outlet;
import org.eclipse.xpand2.output.PostProcessor;
import org.eclipse.xpand2.output.VetoStrategy;

/**
 * Extends the default oaw generator to support working within Eclipse projects without the oaw
 * nature being enabled.
 * 
 * @author <a href="mtaal@elver.org">Martin Taal</a>
 */
public class ArtifactGenerator extends Generator {

  private String projectName;
  private List<Outlet> specificOutlets;

  @Override
  protected void invokeInternal2(final WorkflowContext ctx, final ProgressMonitor monitor,
      final Issues issues) {

    // read templates from projects
    final TexoResourceManager texoResourceManager = new TexoResourceManager();
    texoResourceManager.setProjectName(getProjectName());
    setResourceManager(texoResourceManager);

    final FileCleaner fileCleaner = new FileCleaner();

    final List<VetoStrategy> vetoStrategies = new ArrayList<VetoStrategy>();
    for (final Object o : getBeautifier()) {
      if (o instanceof MergingOutputHandler) {
        ((MergingOutputHandler) o).setProjectName(getProjectName());
        ((MergingOutputHandler) o).setMonitor(monitor);
      }
      if (o instanceof VetoStrategy) {
        vetoStrategies.add((VetoStrategy) o);
      }
    }

    for (final Outlet outlet : getOutlets()) {
      outlet.setPath(EclipseGeneratorUtils.getProjectFilePath(getProjectName())
          + "/" + outlet.getPath()); //$NON-NLS-1$

      // make sure not to overwrite generated files
      // NOTE: apparently the vetoStrategies is a public member
      // the output location tracker needs to be first otherwise it won't
      // always be called
      outlet.vetoStrategies.add(0, fileCleaner.getNewOutputLocationTracker());

      for (final VetoStrategy vs : vetoStrategies) {
        outlet.addVetoStrategy(vs);
      }

      for (final PostProcessor postProcesor : outlet.postprocessors) {
        if (postProcesor instanceof MergingOutputHandler) {
          ((MergingOutputHandler) postProcesor).setProjectName(getProjectName());
          ((MergingOutputHandler) postProcesor).setMonitor(monitor);
        }
        if (postProcesor instanceof VetoStrategy) {
          outlet.addVetoStrategy((VetoStrategy) postProcesor);
        }
      }
    }
    try {
      super.invokeInternal2(ctx, monitor, issues);
      fileCleaner.clean();
    } catch (final Exception e) {
      // TODO: do better logging....
      e.printStackTrace(System.err);
    }
  }

  // overridden to prevent stack overflow because of bug in superclass
  @Override
  public void addAdvices(String advice) {
    addAdvice(advice);
  }

  /**
   * @return the projectName
   */
  public String getProjectName() {
    return projectName;
  }

  /**
   * @param projectName
   *          the projectName to set
   */
  public void setProjectName(final String projectName) {
    this.projectName = projectName;
  }

  /**
   * @return the specificOutlets
   */
  public List<Outlet> getSpecificOutlets() {
    return specificOutlets;
  }

  /**
   * @param specificOutlets
   *          the specificOutlets to set
   */
  public void setSpecificOutlets(final List<Outlet> specificOutlets) {
    this.specificOutlets = specificOutlets;
    for (final Outlet outlet : specificOutlets) {
      addOutlet(outlet);
    }
  }
}
