package org.eclipse.emf.texo.datagenerator;

import java.util.List;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;

/**
 * Model/Ecore related convenience methods to for example read ecore and xsd's.
 * 
 * @author <a href="mtaal@elver.org">Martin Taal</a>
 */
public class DataGeneratorUtils {

  /**
   * See the {@link #isObjectTypeWithEnumBaseType(EDataType)} for information.
   * 
   * @param eDataType
   * @return
   */
  public static EEnum getEnumBaseDataTypeIfObject(EDataType eDataType) {
    if (eDataType instanceof EEnum) {
      return null;
    }
    final ExtendedMetaData extendedMetaData = ExtendedMetaData.INSTANCE;
    for (EDataType baseDataType = eDataType; baseDataType != null; baseDataType = extendedMetaData
        .getBaseType(baseDataType)) {
      if (baseDataType instanceof EEnum) {
        return (EEnum) baseDataType;
      }
    }
    return null;
  }

  /**
   * Returns the instanceclass of the EDataType. If no instance class is set then the base EDataType
   * is used (if present).
   * 
   * @param eDataType
   *          the EDataType for which the instance class is determined.
   * @return the instance class of the EDataType
   * @see ExtendedMetaData#getBaseType(EDataType)
   */
  public static Class<?> getInstanceClass(EDataType eDataType) {
    final Class<?> clz = eDataType.getInstanceClass();
    if (clz != null && clz != Object.class) {
      return eDataType.getInstanceClass();
    }
    if (clz == Object.class) {
      final List<EDataType> memberTypes = ExtendedMetaData.INSTANCE.getMemberTypes(eDataType);
      if (memberTypes != null && memberTypes.size() > 0) {
        return getInstanceClass(memberTypes.get(0));
      }
    }
    final EDataType baseType = ExtendedMetaData.INSTANCE.getBaseType(eDataType);
    if (baseType != null) {
      return getInstanceClass(baseType);
    }
    // default to a string
    return String.class;
  }

  /** Returns true if the passed feature is a wildcard mixed feature */
  public static boolean isMixed(EStructuralFeature feature) {
    EAnnotation eAnnotation = feature
        .getEAnnotation("http:///org/eclipse/emf/ecore/util/ExtendedMetaData"); //$NON-NLS-1$
    if (eAnnotation == null) {
      return false;
    }
    final String kind = eAnnotation.getDetails().get("kind"); //$NON-NLS-1$
    final String name = eAnnotation.getDetails().get("name"); //$NON-NLS-1$
    return kind != null && kind.compareTo("elementWildcard") == 0 && name != null //$NON-NLS-1$
        && name.compareTo(":mixed") == 0; //$NON-NLS-1$
  }

}