/**
 * <copyright>
 *
 * Copyright (c) 2009, 2010 Springsite BV (The Netherlands) and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Martin Taal - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: EEnumDataGenerator.java,v 1.6 2010/03/14 12:55:59 mtaal Exp $
 */

package org.eclipse.emf.texo.datagenerator.attributegenerators;

import java.util.ArrayList;

import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.texo.datagenerator.DataGeneratorUtils;
import org.eclipse.emf.texo.datagenerator.EDataTypeDataGenerator;

/**
 * Generates a value for a EEnum.
 * 
 * @author <a href="mailto:mtaal@elver.org">Martin Taal</a>
 * @version $Revision: 1.6 $
 */

public class EEnumDataGenerator extends EDataTypeDataGenerator {

  @Override
  protected void initialize() {
    // determine the enum values, get one and get an instance and its class
    final EDataType eDataType = getEDataType();
    final EEnum eeNum;
    if (null != DataGeneratorUtils.getEnumBaseDataTypeIfObject(eDataType)) {
      eeNum = DataGeneratorUtils.getEnumBaseDataTypeIfObject(eDataType);
    } else {
      eeNum = (EEnum) getEDataType();
    }
    setValues(new ArrayList<Object>(eeNum.getELiterals()));
  }
}