/**
 * <copyright>
 *
 * Copyright (c) 2009, 2010 Springsite BV (The Netherlands) and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Martin Taal - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: XMLDateDataGenerator.java,v 1.6 2010/03/15 10:18:51 mtaal Exp $
 */

package org.eclipse.emf.texo.datagenerator.attributegenerators;

import java.util.Calendar;

import javax.xml.datatype.XMLGregorianCalendar;

import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.texo.datagenerator.EDataTypeDataGenerator;

/**
 * Generates a XMLGregorianCalendar value.
 * 
 * @author <a href="mailto:mtaal@elver.org">Martin Taal</a>
 * @version $Revision: 1.6 $
 */

public class XMLDateDataGenerator extends EDataTypeDataGenerator {

  private Calendar calendar = Calendar.getInstance();

  @Override
  protected Object getNextValue() {
    calendar.add(Calendar.DATE, 1 + calendar.get(Calendar.DATE));

    final XMLTypeFactory factory = XMLTypePackage.eINSTANCE.getXMLTypeFactory();
    final XMLGregorianCalendar xmlCalendar = factory.createDate("2010-01-01+01:00"); //$NON-NLS-1$
    // final XMLGregorianCalendar xmlCalendar =
    // factory.createDate("2009-04-01T17:17:17Z");
    xmlCalendar.setYear(calendar.get(Calendar.YEAR));
    xmlCalendar.setMonth(1 + calendar.get(Calendar.MONTH));
    xmlCalendar.setDay(calendar.get(Calendar.DATE));
    return xmlCalendar;
  }
}