/**
 * <copyright>
 *
 * Copyright (c) 2010 Springsite BV (The Netherlands) and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Martin Taal - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: GenerateCode.java,v 1.4 2010/03/14 00:56:44 mtaal Exp $
 */
package org.eclipse.emf.texo.eclipse.popup.actions;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.texo.eclipse.Messages;
import org.eclipse.emf.texo.eclipse.ProjectPropertyUtil;
import org.eclipse.emf.texo.generator.ModelController;
import org.eclipse.emf.texo.generator.WorkFlowStarter;
import org.eclipse.emf.texo.modelgenerator.annotator.ModelGenAnnotator;
import org.eclipse.emf.texo.utils.ModelUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/**
 * The generate code menu option. Collects the selected files and their projects and generates code
 * for the packages in the selected files.
 * 
 * @author mtaal
 */
public class GenerateCode implements IObjectActionDelegate {

  private List<IFile> modelFiles = new ArrayList<IFile>();

  /**
   * Constructor for Action1.
   */
  public GenerateCode() {
    super();
  }

  /**
   * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
   */
  public void setActivePart(IAction action, IWorkbenchPart targetPart) {
  }

  /**
   * @see IActionDelegate#run(IAction)
   */
  public void run(IAction action) {
    WorkspaceModifyOperation runnable = new WorkspaceModifyOperation() {
      @Override
      public void execute(IProgressMonitor progressMonitor) {
        generate(progressMonitor);
      }
    };
    try {
      PlatformUI.getWorkbench().getProgressService().run(true, true, runnable);
    } catch (Exception e) {
      throw new IllegalStateException("Exception while generating", e); //$NON-NLS-1$
    }
  }

  private void generate(IProgressMonitor monitor) {
    // sort the modelfiles by project and run by project
    final Map<IProject, List<IFile>> filesByProject = new HashMap<IProject, List<IFile>>();
    for (IFile modelFile : modelFiles) {
      final IProject project = modelFile.getProject();
      if (filesByProject.get(project) == null) {
        filesByProject.put(project, new ArrayList<IFile>());
      }
      filesByProject.get(project).add(modelFile);
    }

    monitor.setTaskName(Messages.getString("generate.Artifacts")); //$NON-NLS-1$
    //    monitor.beginTask(Messages.getString("generate.Artifacts"), IProgressMonitor.UNKNOWN); //$NON-NLS-1$
    for (IProject project : filesByProject.keySet()) {
      generate(monitor, project, filesByProject.get(project));
      monitor.subTask(Messages.getString("generate.Refresh")); //$NON-NLS-1$
      if (monitor.isCanceled()) {
        return;
      }
    }
  }

  private void generate(IProgressMonitor monitor, IProject project, List<IFile> projectModelFiles) {
    monitor.subTask(Messages.getString("generate.Reading")); //$NON-NLS-1$
    final List<URI> uris = new ArrayList<URI>();
    for (final IFile modelFile : modelFiles) {
      uris.add(modelFile.getRawLocationURI());
    }
    final List<EPackage> ePackages = ModelUtils.readEPackages(uris);

    final ModelController modelController = new ModelController();
    modelController.addModelAnnotator(new ModelGenAnnotator());
    modelController.setEPackages(ePackages);
    monitor.subTask(Messages.getString("generate.Annotating")); //$NON-NLS-1$
    modelController.annotate();

    final WorkFlowStarter wfs = new WorkFlowStarter();
    monitor.subTask(Messages.getString("generate.Initialize")); //$NON-NLS-1$
    wfs.setMonitor(monitor);
    wfs.generateModelCode(project.getName(), ePackages, modelController, ProjectPropertyUtil
        .getGenOutputFolder(project));
  }

  /**
   * @see IActionDelegate#selectionChanged(IAction, ISelection)
   */
  public void selectionChanged(IAction action, ISelection selection) {
    if (!(selection instanceof IStructuredSelection)) {
      return;
    }

    final IStructuredSelection structuredSelection = (IStructuredSelection) selection;
    final Iterator<?> it = structuredSelection.iterator();
    modelFiles.clear();
    while (it.hasNext()) {
      final Object obj = it.next();
      if (obj instanceof IFile) {
        modelFiles.add((IFile) obj);
      }
    }
  }

}
